# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.order_enum import OrderEnum
from ..types.payment_intent_cursor_fields import PaymentIntentCursorFields
from ..types.payment_intent_history_response import PaymentIntentHistoryResponse
from ..types.payment_intent_response import PaymentIntentResponse
from ..types.payment_intents_list_response import PaymentIntentsListResponse
from .raw_client import AsyncRawPaymentIntentsClient, RawPaymentIntentsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PaymentIntentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPaymentIntentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPaymentIntentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPaymentIntentsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[PaymentIntentCursorFields] = None,
        object_id: typing.Optional[str] = None,
        object_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentIntentsListResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[PaymentIntentCursorFields]
            Allowed sort fields

        object_id : typing.Optional[str]
            ID of a payable or receivable invoice. If provided, returns only payment intents associated with the specified invoice.

        object_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of payable IDs and/or receivable IDs. If provided, returns only payment intents associated with the specified payable and receivable invoices. Valid but nonexistent IDs do not raise errors but produce no results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentsListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_intents.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            object_id=object_id,
            object_id_in=object_id_in,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, payment_intent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentIntentResponse:
        """
        Parameters
        ----------
        payment_intent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_intents.get_by_id(payment_intent_id='payment_intent_id', )
        """
        _response = self._raw_client.get_by_id(payment_intent_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self, payment_intent_id: str, *, amount: int, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentIntentResponse:
        """
        Parameters
        ----------
        payment_intent_id : str

        amount : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_intents.update_by_id(payment_intent_id='payment_intent_id', amount=1, )
        """
        _response = self._raw_client.update_by_id(payment_intent_id, amount=amount, request_options=request_options)
        return _response.data

    def get_history_by_id(
        self, payment_intent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentIntentHistoryResponse:
        """
        Parameters
        ----------
        payment_intent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentHistoryResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_intents.get_history_by_id(payment_intent_id='payment_intent_id', )
        """
        _response = self._raw_client.get_history_by_id(payment_intent_id, request_options=request_options)
        return _response.data


class AsyncPaymentIntentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPaymentIntentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPaymentIntentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPaymentIntentsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[PaymentIntentCursorFields] = None,
        object_id: typing.Optional[str] = None,
        object_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentIntentsListResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[PaymentIntentCursorFields]
            Allowed sort fields

        object_id : typing.Optional[str]
            ID of a payable or receivable invoice. If provided, returns only payment intents associated with the specified invoice.

        object_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of payable IDs and/or receivable IDs. If provided, returns only payment intents associated with the specified payable and receivable invoices. Valid but nonexistent IDs do not raise errors but produce no results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentsListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_intents.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            object_id=object_id,
            object_id_in=object_id_in,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, payment_intent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentIntentResponse:
        """
        Parameters
        ----------
        payment_intent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_intents.get_by_id(payment_intent_id='payment_intent_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(payment_intent_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self, payment_intent_id: str, *, amount: int, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentIntentResponse:
        """
        Parameters
        ----------
        payment_intent_id : str

        amount : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_intents.update_by_id(payment_intent_id='payment_intent_id', amount=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            payment_intent_id, amount=amount, request_options=request_options
        )
        return _response.data

    async def get_history_by_id(
        self, payment_intent_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentIntentHistoryResponse:
        """
        Parameters
        ----------
        payment_intent_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentIntentHistoryResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_intents.get_history_by_id(payment_intent_id='payment_intent_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_history_by_id(payment_intent_id, request_options=request_options)
        return _response.data
