# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.currency_enum import CurrencyEnum
from ..types.invoice import Invoice
from ..types.monite_all_payment_methods_types import MoniteAllPaymentMethodsTypes
from ..types.payment_account_object import PaymentAccountObject
from ..types.payment_object import PaymentObject
from ..types.public_payment_link_response import PublicPaymentLinkResponse
from .raw_client import AsyncRawPaymentLinksClient, RawPaymentLinksClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PaymentLinksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPaymentLinksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPaymentLinksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPaymentLinksClient
        """
        return self._raw_client

    def create(
        self,
        *,
        payment_methods: typing.Sequence[MoniteAllPaymentMethodsTypes],
        recipient: PaymentAccountObject,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        invoice: typing.Optional[Invoice] = OMIT,
        object: typing.Optional[PaymentObject] = OMIT,
        payment_reference: typing.Optional[str] = OMIT,
        return_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PublicPaymentLinkResponse:
        """
        Parameters
        ----------
        payment_methods : typing.Sequence[MoniteAllPaymentMethodsTypes]

        recipient : PaymentAccountObject

        amount : typing.Optional[int]
            The payment amount in [minor units](https://docs.monite.com/references/currencies#minor-units). Required if `object` is not specified.

        currency : typing.Optional[CurrencyEnum]
            The payment currency. Required if `object` is not specified.

        expires_at : typing.Optional[dt.datetime]

        invoice : typing.Optional[Invoice]
            An object containing information about the invoice being paid. Used only if `object` is not specified.

        object : typing.Optional[PaymentObject]
            If the invoice being paid is a payable or receivable stored in Monite, provide the `object` object containing the invoice type and ID. Otherwise, use the `amount`, `currency`, `payment_reference`, and (optionally) `invoice` fields to specify the invoice-related data.

        payment_reference : typing.Optional[str]
            A payment reference number that the recipient can use to identify the payer or purpose of the transaction. Required if `object` is not specified.

        return_url : typing.Optional[str]
            The URL where to redirect the payer after the payment. If `return_url` is specified, then after the payment is completed the payment page will display the "Return to platform" link that navigates to this URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicPaymentLinkResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import PaymentAccountObject
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_links.create(payment_methods=["sepa_credit"], recipient=PaymentAccountObject(id='id', type="entity", ), )
        """
        _response = self._raw_client.create(
            payment_methods=payment_methods,
            recipient=recipient,
            amount=amount,
            currency=currency,
            expires_at=expires_at,
            invoice=invoice,
            object=object,
            payment_reference=payment_reference,
            return_url=return_url,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PublicPaymentLinkResponse:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicPaymentLinkResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_links.get_by_id(payment_link_id='payment_link_id', )
        """
        _response = self._raw_client.get_by_id(payment_link_id, request_options=request_options)
        return _response.data

    def expire_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PublicPaymentLinkResponse:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicPaymentLinkResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_links.expire_by_id(payment_link_id='payment_link_id', )
        """
        _response = self._raw_client.expire_by_id(payment_link_id, request_options=request_options)
        return _response.data


class AsyncPaymentLinksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPaymentLinksClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPaymentLinksClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPaymentLinksClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        payment_methods: typing.Sequence[MoniteAllPaymentMethodsTypes],
        recipient: PaymentAccountObject,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        invoice: typing.Optional[Invoice] = OMIT,
        object: typing.Optional[PaymentObject] = OMIT,
        payment_reference: typing.Optional[str] = OMIT,
        return_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PublicPaymentLinkResponse:
        """
        Parameters
        ----------
        payment_methods : typing.Sequence[MoniteAllPaymentMethodsTypes]

        recipient : PaymentAccountObject

        amount : typing.Optional[int]
            The payment amount in [minor units](https://docs.monite.com/references/currencies#minor-units). Required if `object` is not specified.

        currency : typing.Optional[CurrencyEnum]
            The payment currency. Required if `object` is not specified.

        expires_at : typing.Optional[dt.datetime]

        invoice : typing.Optional[Invoice]
            An object containing information about the invoice being paid. Used only if `object` is not specified.

        object : typing.Optional[PaymentObject]
            If the invoice being paid is a payable or receivable stored in Monite, provide the `object` object containing the invoice type and ID. Otherwise, use the `amount`, `currency`, `payment_reference`, and (optionally) `invoice` fields to specify the invoice-related data.

        payment_reference : typing.Optional[str]
            A payment reference number that the recipient can use to identify the payer or purpose of the transaction. Required if `object` is not specified.

        return_url : typing.Optional[str]
            The URL where to redirect the payer after the payment. If `return_url` is specified, then after the payment is completed the payment page will display the "Return to platform" link that navigates to this URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicPaymentLinkResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import PaymentAccountObject
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_links.create(payment_methods=["sepa_credit"], recipient=PaymentAccountObject(id='id', type="entity", ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            payment_methods=payment_methods,
            recipient=recipient,
            amount=amount,
            currency=currency,
            expires_at=expires_at,
            invoice=invoice,
            object=object,
            payment_reference=payment_reference,
            return_url=return_url,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PublicPaymentLinkResponse:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicPaymentLinkResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_links.get_by_id(payment_link_id='payment_link_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(payment_link_id, request_options=request_options)
        return _response.data

    async def expire_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PublicPaymentLinkResponse:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PublicPaymentLinkResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_links.expire_by_id(payment_link_id='payment_link_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.expire_by_id(payment_link_id, request_options=request_options)
        return _response.data
