# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.internal_server_error import InternalServerError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.currency_enum import CurrencyEnum
from ..types.invoice import Invoice
from ..types.monite_all_payment_methods_types import MoniteAllPaymentMethodsTypes
from ..types.payment_account_object import PaymentAccountObject
from ..types.payment_object import PaymentObject
from ..types.public_payment_link_response import PublicPaymentLinkResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPaymentLinksClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        payment_methods: typing.Sequence[MoniteAllPaymentMethodsTypes],
        recipient: PaymentAccountObject,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        invoice: typing.Optional[Invoice] = OMIT,
        object: typing.Optional[PaymentObject] = OMIT,
        payment_reference: typing.Optional[str] = OMIT,
        return_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PublicPaymentLinkResponse]:
        """
        Parameters
        ----------
        payment_methods : typing.Sequence[MoniteAllPaymentMethodsTypes]

        recipient : PaymentAccountObject

        amount : typing.Optional[int]
            The payment amount in [minor units](https://docs.monite.com/references/currencies#minor-units). Required if `object` is not specified.

        currency : typing.Optional[CurrencyEnum]
            The payment currency. Required if `object` is not specified.

        expires_at : typing.Optional[dt.datetime]

        invoice : typing.Optional[Invoice]
            An object containing information about the invoice being paid. Used only if `object` is not specified.

        object : typing.Optional[PaymentObject]
            If the invoice being paid is a payable or receivable stored in Monite, provide the `object` object containing the invoice type and ID. Otherwise, use the `amount`, `currency`, `payment_reference`, and (optionally) `invoice` fields to specify the invoice-related data.

        payment_reference : typing.Optional[str]
            A payment reference number that the recipient can use to identify the payer or purpose of the transaction. Required if `object` is not specified.

        return_url : typing.Optional[str]
            The URL where to redirect the payer after the payment. If `return_url` is specified, then after the payment is completed the payment page will display the "Return to platform" link that navigates to this URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PublicPaymentLinkResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "payment_links",
            method="POST",
            json={
                "amount": amount,
                "currency": currency,
                "expires_at": expires_at,
                "invoice": convert_and_respect_annotation_metadata(
                    object_=invoice, annotation=Invoice, direction="write"
                ),
                "object": convert_and_respect_annotation_metadata(
                    object_=object, annotation=PaymentObject, direction="write"
                ),
                "payment_methods": payment_methods,
                "payment_reference": payment_reference,
                "recipient": convert_and_respect_annotation_metadata(
                    object_=recipient, annotation=PaymentAccountObject, direction="write"
                ),
                "return_url": return_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PublicPaymentLinkResponse,
                    parse_obj_as(
                        type_=PublicPaymentLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PublicPaymentLinkResponse]:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PublicPaymentLinkResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_links/{jsonable_encoder(payment_link_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PublicPaymentLinkResponse,
                    parse_obj_as(
                        type_=PublicPaymentLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def expire_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PublicPaymentLinkResponse]:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PublicPaymentLinkResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_links/{jsonable_encoder(payment_link_id)}/expire",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PublicPaymentLinkResponse,
                    parse_obj_as(
                        type_=PublicPaymentLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPaymentLinksClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        payment_methods: typing.Sequence[MoniteAllPaymentMethodsTypes],
        recipient: PaymentAccountObject,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        expires_at: typing.Optional[dt.datetime] = OMIT,
        invoice: typing.Optional[Invoice] = OMIT,
        object: typing.Optional[PaymentObject] = OMIT,
        payment_reference: typing.Optional[str] = OMIT,
        return_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PublicPaymentLinkResponse]:
        """
        Parameters
        ----------
        payment_methods : typing.Sequence[MoniteAllPaymentMethodsTypes]

        recipient : PaymentAccountObject

        amount : typing.Optional[int]
            The payment amount in [minor units](https://docs.monite.com/references/currencies#minor-units). Required if `object` is not specified.

        currency : typing.Optional[CurrencyEnum]
            The payment currency. Required if `object` is not specified.

        expires_at : typing.Optional[dt.datetime]

        invoice : typing.Optional[Invoice]
            An object containing information about the invoice being paid. Used only if `object` is not specified.

        object : typing.Optional[PaymentObject]
            If the invoice being paid is a payable or receivable stored in Monite, provide the `object` object containing the invoice type and ID. Otherwise, use the `amount`, `currency`, `payment_reference`, and (optionally) `invoice` fields to specify the invoice-related data.

        payment_reference : typing.Optional[str]
            A payment reference number that the recipient can use to identify the payer or purpose of the transaction. Required if `object` is not specified.

        return_url : typing.Optional[str]
            The URL where to redirect the payer after the payment. If `return_url` is specified, then after the payment is completed the payment page will display the "Return to platform" link that navigates to this URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PublicPaymentLinkResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "payment_links",
            method="POST",
            json={
                "amount": amount,
                "currency": currency,
                "expires_at": expires_at,
                "invoice": convert_and_respect_annotation_metadata(
                    object_=invoice, annotation=Invoice, direction="write"
                ),
                "object": convert_and_respect_annotation_metadata(
                    object_=object, annotation=PaymentObject, direction="write"
                ),
                "payment_methods": payment_methods,
                "payment_reference": payment_reference,
                "recipient": convert_and_respect_annotation_metadata(
                    object_=recipient, annotation=PaymentAccountObject, direction="write"
                ),
                "return_url": return_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PublicPaymentLinkResponse,
                    parse_obj_as(
                        type_=PublicPaymentLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PublicPaymentLinkResponse]:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PublicPaymentLinkResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_links/{jsonable_encoder(payment_link_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PublicPaymentLinkResponse,
                    parse_obj_as(
                        type_=PublicPaymentLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def expire_by_id(
        self, payment_link_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PublicPaymentLinkResponse]:
        """
        Parameters
        ----------
        payment_link_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PublicPaymentLinkResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_links/{jsonable_encoder(payment_link_id)}/expire",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PublicPaymentLinkResponse,
                    parse_obj_as(
                        type_=PublicPaymentLinkResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
