# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.currency_enum import CurrencyEnum
from ..types.object_type_enum import ObjectTypeEnum
from ..types.order_enum import OrderEnum
from ..types.payment_record_cursor_fields import PaymentRecordCursorFields
from ..types.payment_record_object_request import PaymentRecordObjectRequest
from ..types.payment_record_response import PaymentRecordResponse
from ..types.payment_record_response_list import PaymentRecordResponseList
from ..types.payment_record_status_enum import PaymentRecordStatusEnum
from .raw_client import AsyncRawPaymentRecordsClient, RawPaymentRecordsClient
from .types.payment_record_request_status import PaymentRecordRequestStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PaymentRecordsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPaymentRecordsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPaymentRecordsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPaymentRecordsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[PaymentRecordCursorFields] = None,
        is_external: typing.Optional[bool] = None,
        object_id: typing.Optional[str] = None,
        object_type: typing.Optional[ObjectTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        paid_at_gt: typing.Optional[dt.datetime] = None,
        paid_at_lt: typing.Optional[dt.datetime] = None,
        planned_payment_date: typing.Optional[str] = None,
        planned_payment_date_gt: typing.Optional[str] = None,
        planned_payment_date_lt: typing.Optional[str] = None,
        planned_payment_date_gte: typing.Optional[str] = None,
        planned_payment_date_lte: typing.Optional[str] = None,
        status: typing.Optional[PaymentRecordStatusEnum] = None,
        payment_intent_status: typing.Optional[str] = None,
        payment_method: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponseList:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[PaymentRecordCursorFields]
            Allowed sort fields

        is_external : typing.Optional[bool]
            Identifies whether payment is from our rails or external system

        object_id : typing.Optional[str]
            ID of the object, that is connected to payment

        object_type : typing.Optional[ObjectTypeEnum]
            Type of an object, which is connected with payment

        created_at_gt : typing.Optional[dt.datetime]
            Created after this datetime (exclusive)

        created_at_lt : typing.Optional[dt.datetime]
            Created before this datetime (exclusive)

        updated_at_gt : typing.Optional[dt.datetime]
            Updated after this datetime (exclusive)

        updated_at_lt : typing.Optional[dt.datetime]
            Updated before this datetime (exclusive)

        paid_at_gt : typing.Optional[dt.datetime]
            Paid after this datetime (exclusive)

        paid_at_lt : typing.Optional[dt.datetime]
            Paid before this datetime (exclusive)

        planned_payment_date : typing.Optional[str]
            Optional date of the upcoming payment (equality)

        planned_payment_date_gt : typing.Optional[str]
            Planned after this date (exclusive)

        planned_payment_date_lt : typing.Optional[str]
            Planned before this date (exclusive)

        planned_payment_date_gte : typing.Optional[str]
            Planned at or after this date (inclusive)

        planned_payment_date_lte : typing.Optional[str]
            Planned at or before this date (inclusive)

        status : typing.Optional[PaymentRecordStatusEnum]
            One of the payment record statuses

        payment_intent_status : typing.Optional[str]
            Payment intent status as a raw string

        payment_method : typing.Optional[str]
            Payment method used for the transaction

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponseList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            is_external=is_external,
            object_id=object_id,
            object_type=object_type,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            paid_at_gt=paid_at_gt,
            paid_at_lt=paid_at_lt,
            planned_payment_date=planned_payment_date,
            planned_payment_date_gt=planned_payment_date_gt,
            planned_payment_date_lt=planned_payment_date_lt,
            planned_payment_date_gte=planned_payment_date_gte,
            planned_payment_date_lte=planned_payment_date_lte,
            status=status,
            payment_intent_status=payment_intent_status,
            payment_method=payment_method,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        amount: int,
        currency: CurrencyEnum,
        object: PaymentRecordObjectRequest,
        payment_intent_id: str,
        entity_user_id: typing.Optional[str] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        status: typing.Optional[PaymentRecordRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        amount : int
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : CurrencyEnum
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        object : PaymentRecordObjectRequest
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        payment_intent_id : str
            Identifier for an payment intent.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        status : typing.Optional[PaymentRecordRequestStatus]
            Status of the payment record indicating its current stage (e.g., created, processing, succeeded).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import PaymentRecordObjectRequest
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.create(amount=1, currency="AED", object=PaymentRecordObjectRequest(id='id', type="receivable", ), payment_intent_id='payment_intent_id', )
        """
        _response = self._raw_client.create(
            amount=amount,
            currency=currency,
            object=object,
            payment_intent_id=payment_intent_id,
            entity_user_id=entity_user_id,
            paid_at=paid_at,
            payment_intent_status=payment_intent_status,
            payment_method=payment_method,
            planned_payment_date=planned_payment_date,
            status=status,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, payment_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.get_by_id(payment_record_id='payment_record_id', )
        """
        _response = self._raw_client.get_by_id(payment_record_id, request_options=request_options)
        return _response.data

    def patch_payment_records_id(
        self,
        payment_record_id: str,
        *,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        entity_user_id: typing.Optional[str] = OMIT,
        object: typing.Optional[PaymentRecordObjectRequest] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_id: typing.Optional[str] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        amount : typing.Optional[int]
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : typing.Optional[CurrencyEnum]
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        object : typing.Optional[PaymentRecordObjectRequest]
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_id : typing.Optional[str]
            Identifier for an payment intent.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.patch_payment_records_id(payment_record_id='payment_record_id', )
        """
        _response = self._raw_client.patch_payment_records_id(
            payment_record_id,
            amount=amount,
            currency=currency,
            entity_user_id=entity_user_id,
            object=object,
            paid_at=paid_at,
            payment_intent_id=payment_intent_id,
            payment_intent_status=payment_intent_status,
            payment_method=payment_method,
            planned_payment_date=planned_payment_date,
            request_options=request_options,
        )
        return _response.data

    def post_payment_records_id_cancel(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.post_payment_records_id_cancel(payment_record_id='payment_record_id', )
        """
        _response = self._raw_client.post_payment_records_id_cancel(
            payment_record_id, payment_intent_status=payment_intent_status, request_options=request_options
        )
        return _response.data

    def post_payment_records_id_mark_as_succeeded(
        self,
        payment_record_id: str,
        *,
        paid_at: dt.datetime,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        paid_at : dt.datetime
            Timestamp marking when the payment was executed.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        import datetime
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.post_payment_records_id_mark_as_succeeded(payment_record_id='payment_record_id', paid_at=datetime.datetime.fromisoformat("2024-01-15 09:30:00+00:00", ), )
        """
        _response = self._raw_client.post_payment_records_id_mark_as_succeeded(
            payment_record_id,
            paid_at=paid_at,
            payment_intent_status=payment_intent_status,
            request_options=request_options,
        )
        return _response.data

    def post_payment_records_id_start_processing(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_records.post_payment_records_id_start_processing(payment_record_id='payment_record_id', )
        """
        _response = self._raw_client.post_payment_records_id_start_processing(
            payment_record_id, payment_intent_status=payment_intent_status, request_options=request_options
        )
        return _response.data


class AsyncPaymentRecordsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPaymentRecordsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPaymentRecordsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPaymentRecordsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[PaymentRecordCursorFields] = None,
        is_external: typing.Optional[bool] = None,
        object_id: typing.Optional[str] = None,
        object_type: typing.Optional[ObjectTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        paid_at_gt: typing.Optional[dt.datetime] = None,
        paid_at_lt: typing.Optional[dt.datetime] = None,
        planned_payment_date: typing.Optional[str] = None,
        planned_payment_date_gt: typing.Optional[str] = None,
        planned_payment_date_lt: typing.Optional[str] = None,
        planned_payment_date_gte: typing.Optional[str] = None,
        planned_payment_date_lte: typing.Optional[str] = None,
        status: typing.Optional[PaymentRecordStatusEnum] = None,
        payment_intent_status: typing.Optional[str] = None,
        payment_method: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponseList:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[PaymentRecordCursorFields]
            Allowed sort fields

        is_external : typing.Optional[bool]
            Identifies whether payment is from our rails or external system

        object_id : typing.Optional[str]
            ID of the object, that is connected to payment

        object_type : typing.Optional[ObjectTypeEnum]
            Type of an object, which is connected with payment

        created_at_gt : typing.Optional[dt.datetime]
            Created after this datetime (exclusive)

        created_at_lt : typing.Optional[dt.datetime]
            Created before this datetime (exclusive)

        updated_at_gt : typing.Optional[dt.datetime]
            Updated after this datetime (exclusive)

        updated_at_lt : typing.Optional[dt.datetime]
            Updated before this datetime (exclusive)

        paid_at_gt : typing.Optional[dt.datetime]
            Paid after this datetime (exclusive)

        paid_at_lt : typing.Optional[dt.datetime]
            Paid before this datetime (exclusive)

        planned_payment_date : typing.Optional[str]
            Optional date of the upcoming payment (equality)

        planned_payment_date_gt : typing.Optional[str]
            Planned after this date (exclusive)

        planned_payment_date_lt : typing.Optional[str]
            Planned before this date (exclusive)

        planned_payment_date_gte : typing.Optional[str]
            Planned at or after this date (inclusive)

        planned_payment_date_lte : typing.Optional[str]
            Planned at or before this date (inclusive)

        status : typing.Optional[PaymentRecordStatusEnum]
            One of the payment record statuses

        payment_intent_status : typing.Optional[str]
            Payment intent status as a raw string

        payment_method : typing.Optional[str]
            Payment method used for the transaction

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponseList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            is_external=is_external,
            object_id=object_id,
            object_type=object_type,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            updated_at_gt=updated_at_gt,
            updated_at_lt=updated_at_lt,
            paid_at_gt=paid_at_gt,
            paid_at_lt=paid_at_lt,
            planned_payment_date=planned_payment_date,
            planned_payment_date_gt=planned_payment_date_gt,
            planned_payment_date_lt=planned_payment_date_lt,
            planned_payment_date_gte=planned_payment_date_gte,
            planned_payment_date_lte=planned_payment_date_lte,
            status=status,
            payment_intent_status=payment_intent_status,
            payment_method=payment_method,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        amount: int,
        currency: CurrencyEnum,
        object: PaymentRecordObjectRequest,
        payment_intent_id: str,
        entity_user_id: typing.Optional[str] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        status: typing.Optional[PaymentRecordRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        amount : int
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : CurrencyEnum
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        object : PaymentRecordObjectRequest
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        payment_intent_id : str
            Identifier for an payment intent.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        status : typing.Optional[PaymentRecordRequestStatus]
            Status of the payment record indicating its current stage (e.g., created, processing, succeeded).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import PaymentRecordObjectRequest
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.create(amount=1, currency="AED", object=PaymentRecordObjectRequest(id='id', type="receivable", ), payment_intent_id='payment_intent_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            amount=amount,
            currency=currency,
            object=object,
            payment_intent_id=payment_intent_id,
            entity_user_id=entity_user_id,
            paid_at=paid_at,
            payment_intent_status=payment_intent_status,
            payment_method=payment_method,
            planned_payment_date=planned_payment_date,
            status=status,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, payment_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.get_by_id(payment_record_id='payment_record_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(payment_record_id, request_options=request_options)
        return _response.data

    async def patch_payment_records_id(
        self,
        payment_record_id: str,
        *,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        entity_user_id: typing.Optional[str] = OMIT,
        object: typing.Optional[PaymentRecordObjectRequest] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_id: typing.Optional[str] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        amount : typing.Optional[int]
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : typing.Optional[CurrencyEnum]
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        object : typing.Optional[PaymentRecordObjectRequest]
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_id : typing.Optional[str]
            Identifier for an payment intent.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.patch_payment_records_id(payment_record_id='payment_record_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch_payment_records_id(
            payment_record_id,
            amount=amount,
            currency=currency,
            entity_user_id=entity_user_id,
            object=object,
            paid_at=paid_at,
            payment_intent_id=payment_intent_id,
            payment_intent_status=payment_intent_status,
            payment_method=payment_method,
            planned_payment_date=planned_payment_date,
            request_options=request_options,
        )
        return _response.data

    async def post_payment_records_id_cancel(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.post_payment_records_id_cancel(payment_record_id='payment_record_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payment_records_id_cancel(
            payment_record_id, payment_intent_status=payment_intent_status, request_options=request_options
        )
        return _response.data

    async def post_payment_records_id_mark_as_succeeded(
        self,
        payment_record_id: str,
        *,
        paid_at: dt.datetime,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        paid_at : dt.datetime
            Timestamp marking when the payment was executed.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import datetime
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.post_payment_records_id_mark_as_succeeded(payment_record_id='payment_record_id', paid_at=datetime.datetime.fromisoformat("2024-01-15 09:30:00+00:00", ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payment_records_id_mark_as_succeeded(
            payment_record_id,
            paid_at=paid_at,
            payment_intent_status=payment_intent_status,
            request_options=request_options,
        )
        return _response.data

    async def post_payment_records_id_start_processing(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentRecordResponse:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentRecordResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_records.post_payment_records_id_start_processing(payment_record_id='payment_record_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.post_payment_records_id_start_processing(
            payment_record_id, payment_intent_status=payment_intent_status, request_options=request_options
        )
        return _response.data
