# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.internal_server_error import InternalServerError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.currency_enum import CurrencyEnum
from ..types.object_type_enum import ObjectTypeEnum
from ..types.order_enum import OrderEnum
from ..types.payment_record_cursor_fields import PaymentRecordCursorFields
from ..types.payment_record_object_request import PaymentRecordObjectRequest
from ..types.payment_record_response import PaymentRecordResponse
from ..types.payment_record_response_list import PaymentRecordResponseList
from ..types.payment_record_status_enum import PaymentRecordStatusEnum
from .types.payment_record_request_status import PaymentRecordRequestStatus

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPaymentRecordsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[PaymentRecordCursorFields] = None,
        is_external: typing.Optional[bool] = None,
        object_id: typing.Optional[str] = None,
        object_type: typing.Optional[ObjectTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        paid_at_gt: typing.Optional[dt.datetime] = None,
        paid_at_lt: typing.Optional[dt.datetime] = None,
        planned_payment_date: typing.Optional[str] = None,
        planned_payment_date_gt: typing.Optional[str] = None,
        planned_payment_date_lt: typing.Optional[str] = None,
        planned_payment_date_gte: typing.Optional[str] = None,
        planned_payment_date_lte: typing.Optional[str] = None,
        status: typing.Optional[PaymentRecordStatusEnum] = None,
        payment_intent_status: typing.Optional[str] = None,
        payment_method: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaymentRecordResponseList]:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[PaymentRecordCursorFields]
            Allowed sort fields

        is_external : typing.Optional[bool]
            Identifies whether payment is from our rails or external system

        object_id : typing.Optional[str]
            ID of the object, that is connected to payment

        object_type : typing.Optional[ObjectTypeEnum]
            Type of an object, which is connected with payment

        created_at_gt : typing.Optional[dt.datetime]
            Created after this datetime (exclusive)

        created_at_lt : typing.Optional[dt.datetime]
            Created before this datetime (exclusive)

        updated_at_gt : typing.Optional[dt.datetime]
            Updated after this datetime (exclusive)

        updated_at_lt : typing.Optional[dt.datetime]
            Updated before this datetime (exclusive)

        paid_at_gt : typing.Optional[dt.datetime]
            Paid after this datetime (exclusive)

        paid_at_lt : typing.Optional[dt.datetime]
            Paid before this datetime (exclusive)

        planned_payment_date : typing.Optional[str]
            Optional date of the upcoming payment (equality)

        planned_payment_date_gt : typing.Optional[str]
            Planned after this date (exclusive)

        planned_payment_date_lt : typing.Optional[str]
            Planned before this date (exclusive)

        planned_payment_date_gte : typing.Optional[str]
            Planned at or after this date (inclusive)

        planned_payment_date_lte : typing.Optional[str]
            Planned at or before this date (inclusive)

        status : typing.Optional[PaymentRecordStatusEnum]
            One of the payment record statuses

        payment_intent_status : typing.Optional[str]
            Payment intent status as a raw string

        payment_method : typing.Optional[str]
            Payment method used for the transaction

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponseList]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "payment_records",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "is_external": is_external,
                "object_id": object_id,
                "object_type": object_type,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "updated_at__gt": serialize_datetime(updated_at_gt) if updated_at_gt is not None else None,
                "updated_at__lt": serialize_datetime(updated_at_lt) if updated_at_lt is not None else None,
                "paid_at__gt": serialize_datetime(paid_at_gt) if paid_at_gt is not None else None,
                "paid_at__lt": serialize_datetime(paid_at_lt) if paid_at_lt is not None else None,
                "planned_payment_date": planned_payment_date,
                "planned_payment_date__gt": planned_payment_date_gt,
                "planned_payment_date__lt": planned_payment_date_lt,
                "planned_payment_date__gte": planned_payment_date_gte,
                "planned_payment_date__lte": planned_payment_date_lte,
                "status": status,
                "payment_intent_status": payment_intent_status,
                "payment_method": payment_method,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponseList,
                    parse_obj_as(
                        type_=PaymentRecordResponseList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        amount: int,
        currency: CurrencyEnum,
        object: PaymentRecordObjectRequest,
        payment_intent_id: str,
        entity_user_id: typing.Optional[str] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        status: typing.Optional[PaymentRecordRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        amount : int
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : CurrencyEnum
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        object : PaymentRecordObjectRequest
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        payment_intent_id : str
            Identifier for an payment intent.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        status : typing.Optional[PaymentRecordRequestStatus]
            Status of the payment record indicating its current stage (e.g., created, processing, succeeded).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "payment_records",
            method="POST",
            json={
                "amount": amount,
                "currency": currency,
                "entity_user_id": entity_user_id,
                "object": convert_and_respect_annotation_metadata(
                    object_=object, annotation=PaymentRecordObjectRequest, direction="write"
                ),
                "paid_at": paid_at,
                "payment_intent_id": payment_intent_id,
                "payment_intent_status": payment_intent_status,
                "payment_method": payment_method,
                "planned_payment_date": planned_payment_date,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, payment_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def patch_payment_records_id(
        self,
        payment_record_id: str,
        *,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        entity_user_id: typing.Optional[str] = OMIT,
        object: typing.Optional[PaymentRecordObjectRequest] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_id: typing.Optional[str] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        amount : typing.Optional[int]
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : typing.Optional[CurrencyEnum]
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        object : typing.Optional[PaymentRecordObjectRequest]
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_id : typing.Optional[str]
            Identifier for an payment intent.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}",
            method="PATCH",
            json={
                "amount": amount,
                "currency": currency,
                "entity_user_id": entity_user_id,
                "object": convert_and_respect_annotation_metadata(
                    object_=object, annotation=PaymentRecordObjectRequest, direction="write"
                ),
                "paid_at": paid_at,
                "payment_intent_id": payment_intent_id,
                "payment_intent_status": payment_intent_status,
                "payment_method": payment_method,
                "planned_payment_date": planned_payment_date,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_payment_records_id_cancel(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}/cancel",
            method="POST",
            json={
                "payment_intent_status": payment_intent_status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_payment_records_id_mark_as_succeeded(
        self,
        payment_record_id: str,
        *,
        paid_at: dt.datetime,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        paid_at : dt.datetime
            Timestamp marking when the payment was executed.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}/mark_as_succeeded",
            method="POST",
            json={
                "paid_at": paid_at,
                "payment_intent_status": payment_intent_status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def post_payment_records_id_start_processing(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}/start_processing",
            method="POST",
            json={
                "payment_intent_status": payment_intent_status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPaymentRecordsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[PaymentRecordCursorFields] = None,
        is_external: typing.Optional[bool] = None,
        object_id: typing.Optional[str] = None,
        object_type: typing.Optional[ObjectTypeEnum] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        updated_at_gt: typing.Optional[dt.datetime] = None,
        updated_at_lt: typing.Optional[dt.datetime] = None,
        paid_at_gt: typing.Optional[dt.datetime] = None,
        paid_at_lt: typing.Optional[dt.datetime] = None,
        planned_payment_date: typing.Optional[str] = None,
        planned_payment_date_gt: typing.Optional[str] = None,
        planned_payment_date_lt: typing.Optional[str] = None,
        planned_payment_date_gte: typing.Optional[str] = None,
        planned_payment_date_lte: typing.Optional[str] = None,
        status: typing.Optional[PaymentRecordStatusEnum] = None,
        payment_intent_status: typing.Optional[str] = None,
        payment_method: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaymentRecordResponseList]:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Order by

        limit : typing.Optional[int]
            Max is 100

        pagination_token : typing.Optional[str]
            A token, obtained from previous page. Prior over other filters

        sort : typing.Optional[PaymentRecordCursorFields]
            Allowed sort fields

        is_external : typing.Optional[bool]
            Identifies whether payment is from our rails or external system

        object_id : typing.Optional[str]
            ID of the object, that is connected to payment

        object_type : typing.Optional[ObjectTypeEnum]
            Type of an object, which is connected with payment

        created_at_gt : typing.Optional[dt.datetime]
            Created after this datetime (exclusive)

        created_at_lt : typing.Optional[dt.datetime]
            Created before this datetime (exclusive)

        updated_at_gt : typing.Optional[dt.datetime]
            Updated after this datetime (exclusive)

        updated_at_lt : typing.Optional[dt.datetime]
            Updated before this datetime (exclusive)

        paid_at_gt : typing.Optional[dt.datetime]
            Paid after this datetime (exclusive)

        paid_at_lt : typing.Optional[dt.datetime]
            Paid before this datetime (exclusive)

        planned_payment_date : typing.Optional[str]
            Optional date of the upcoming payment (equality)

        planned_payment_date_gt : typing.Optional[str]
            Planned after this date (exclusive)

        planned_payment_date_lt : typing.Optional[str]
            Planned before this date (exclusive)

        planned_payment_date_gte : typing.Optional[str]
            Planned at or after this date (inclusive)

        planned_payment_date_lte : typing.Optional[str]
            Planned at or before this date (inclusive)

        status : typing.Optional[PaymentRecordStatusEnum]
            One of the payment record statuses

        payment_intent_status : typing.Optional[str]
            Payment intent status as a raw string

        payment_method : typing.Optional[str]
            Payment method used for the transaction

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponseList]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "payment_records",
            method="GET",
            params={
                "order": order,
                "limit": limit,
                "pagination_token": pagination_token,
                "sort": sort,
                "is_external": is_external,
                "object_id": object_id,
                "object_type": object_type,
                "created_at__gt": serialize_datetime(created_at_gt) if created_at_gt is not None else None,
                "created_at__lt": serialize_datetime(created_at_lt) if created_at_lt is not None else None,
                "updated_at__gt": serialize_datetime(updated_at_gt) if updated_at_gt is not None else None,
                "updated_at__lt": serialize_datetime(updated_at_lt) if updated_at_lt is not None else None,
                "paid_at__gt": serialize_datetime(paid_at_gt) if paid_at_gt is not None else None,
                "paid_at__lt": serialize_datetime(paid_at_lt) if paid_at_lt is not None else None,
                "planned_payment_date": planned_payment_date,
                "planned_payment_date__gt": planned_payment_date_gt,
                "planned_payment_date__lt": planned_payment_date_lt,
                "planned_payment_date__gte": planned_payment_date_gte,
                "planned_payment_date__lte": planned_payment_date_lte,
                "status": status,
                "payment_intent_status": payment_intent_status,
                "payment_method": payment_method,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponseList,
                    parse_obj_as(
                        type_=PaymentRecordResponseList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        amount: int,
        currency: CurrencyEnum,
        object: PaymentRecordObjectRequest,
        payment_intent_id: str,
        entity_user_id: typing.Optional[str] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        status: typing.Optional[PaymentRecordRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        amount : int
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : CurrencyEnum
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        object : PaymentRecordObjectRequest
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        payment_intent_id : str
            Identifier for an payment intent.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        status : typing.Optional[PaymentRecordRequestStatus]
            Status of the payment record indicating its current stage (e.g., created, processing, succeeded).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "payment_records",
            method="POST",
            json={
                "amount": amount,
                "currency": currency,
                "entity_user_id": entity_user_id,
                "object": convert_and_respect_annotation_metadata(
                    object_=object, annotation=PaymentRecordObjectRequest, direction="write"
                ),
                "paid_at": paid_at,
                "payment_intent_id": payment_intent_id,
                "payment_intent_status": payment_intent_status,
                "payment_method": payment_method,
                "planned_payment_date": planned_payment_date,
                "status": status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, payment_record_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def patch_payment_records_id(
        self,
        payment_record_id: str,
        *,
        amount: typing.Optional[int] = OMIT,
        currency: typing.Optional[CurrencyEnum] = OMIT,
        entity_user_id: typing.Optional[str] = OMIT,
        object: typing.Optional[PaymentRecordObjectRequest] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        payment_intent_id: typing.Optional[str] = OMIT,
        payment_intent_status: typing.Optional[str] = OMIT,
        payment_method: typing.Optional[str] = OMIT,
        planned_payment_date: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        amount : typing.Optional[int]
            Positive amount in case of successful payment, negative amount in case of payment failure or refund, represented in minor currency units (e.g., cents).

        currency : typing.Optional[CurrencyEnum]
            Currency code (ISO 4217) indicating the currency in which the payment was made.

        entity_user_id : typing.Optional[str]
            ID of the user associated with the payment, if applicable.

        object : typing.Optional[PaymentRecordObjectRequest]
            Reference object linked to this payment record, indicating the type (receivable or payable) and its identifier.

        paid_at : typing.Optional[dt.datetime]
            Timestamp marking when the payment was executed. Null if payment hasn't occurred yet.

        payment_intent_id : typing.Optional[str]
            Identifier for an payment intent.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        payment_method : typing.Optional[str]
            Payment method used or planned for the transaction.

        planned_payment_date : typing.Optional[str]
            Scheduled date for future payments, required when the payment is planned but not yet executed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}",
            method="PATCH",
            json={
                "amount": amount,
                "currency": currency,
                "entity_user_id": entity_user_id,
                "object": convert_and_respect_annotation_metadata(
                    object_=object, annotation=PaymentRecordObjectRequest, direction="write"
                ),
                "paid_at": paid_at,
                "payment_intent_id": payment_intent_id,
                "payment_intent_status": payment_intent_status,
                "payment_method": payment_method,
                "planned_payment_date": planned_payment_date,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_payment_records_id_cancel(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}/cancel",
            method="POST",
            json={
                "payment_intent_status": payment_intent_status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_payment_records_id_mark_as_succeeded(
        self,
        payment_record_id: str,
        *,
        paid_at: dt.datetime,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        paid_at : dt.datetime
            Timestamp marking when the payment was executed.

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}/mark_as_succeeded",
            method="POST",
            json={
                "paid_at": paid_at,
                "payment_intent_status": payment_intent_status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def post_payment_records_id_start_processing(
        self,
        payment_record_id: str,
        *,
        payment_intent_status: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PaymentRecordResponse]:
        """
        Parameters
        ----------
        payment_record_id : str

        payment_intent_status : typing.Optional[str]
            Raw status string of the external payment intent.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PaymentRecordResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"payment_records/{jsonable_encoder(payment_record_id)}/start_processing",
            method="POST",
            json={
                "payment_intent_status": payment_intent_status,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PaymentRecordResponse,
                    parse_obj_as(
                        type_=PaymentRecordResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
