# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.get_all_payment_reminders import GetAllPaymentReminders
from ..types.payment_reminder_response import PaymentReminderResponse
from ..types.recipients import Recipients
from ..types.reminder import Reminder
from .raw_client import AsyncRawPaymentRemindersClient, RawPaymentRemindersClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PaymentRemindersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPaymentRemindersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPaymentRemindersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPaymentRemindersClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetAllPaymentReminders:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAllPaymentReminders
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_reminders.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        recipients: typing.Optional[Recipients] = OMIT,
        term1reminder: typing.Optional[Reminder] = OMIT,
        term2reminder: typing.Optional[Reminder] = OMIT,
        term_final_reminder: typing.Optional[Reminder] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentReminderResponse:
        """
        Parameters
        ----------
        name : str

        recipients : typing.Optional[Recipients]

        term1reminder : typing.Optional[Reminder]
            Reminder to send for first payment term

        term2reminder : typing.Optional[Reminder]
            Reminder to send for second payment term

        term_final_reminder : typing.Optional[Reminder]
            Reminder to send for final payment term

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentReminderResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_reminders.create(name='name', )
        """
        _response = self._raw_client.create(
            name=name,
            recipients=recipients,
            term1reminder=term1reminder,
            term2reminder=term2reminder,
            term_final_reminder=term_final_reminder,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, payment_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentReminderResponse:
        """
        Parameters
        ----------
        payment_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentReminderResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_reminders.get_by_id(payment_reminder_id='payment_reminder_id', )
        """
        _response = self._raw_client.get_by_id(payment_reminder_id, request_options=request_options)
        return _response.data

    def delete_by_id(
        self, payment_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        payment_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_reminders.delete_by_id(payment_reminder_id='payment_reminder_id', )
        """
        _response = self._raw_client.delete_by_id(payment_reminder_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        payment_reminder_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        term1reminder: typing.Optional[Reminder] = OMIT,
        term2reminder: typing.Optional[Reminder] = OMIT,
        term_final_reminder: typing.Optional[Reminder] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentReminderResponse:
        """
        Parameters
        ----------
        payment_reminder_id : str

        name : typing.Optional[str]

        recipients : typing.Optional[Recipients]

        term1reminder : typing.Optional[Reminder]
            Reminder to send for first payment term

        term2reminder : typing.Optional[Reminder]
            Reminder to send for second payment term

        term_final_reminder : typing.Optional[Reminder]
            Reminder to send for final payment term

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentReminderResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_reminders.update_by_id(payment_reminder_id='payment_reminder_id', )
        """
        _response = self._raw_client.update_by_id(
            payment_reminder_id,
            name=name,
            recipients=recipients,
            term1reminder=term1reminder,
            term2reminder=term2reminder,
            term_final_reminder=term_final_reminder,
            request_options=request_options,
        )
        return _response.data


class AsyncPaymentRemindersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPaymentRemindersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPaymentRemindersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPaymentRemindersClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetAllPaymentReminders:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAllPaymentReminders
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_reminders.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        recipients: typing.Optional[Recipients] = OMIT,
        term1reminder: typing.Optional[Reminder] = OMIT,
        term2reminder: typing.Optional[Reminder] = OMIT,
        term_final_reminder: typing.Optional[Reminder] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentReminderResponse:
        """
        Parameters
        ----------
        name : str

        recipients : typing.Optional[Recipients]

        term1reminder : typing.Optional[Reminder]
            Reminder to send for first payment term

        term2reminder : typing.Optional[Reminder]
            Reminder to send for second payment term

        term_final_reminder : typing.Optional[Reminder]
            Reminder to send for final payment term

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentReminderResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_reminders.create(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            recipients=recipients,
            term1reminder=term1reminder,
            term2reminder=term2reminder,
            term_final_reminder=term_final_reminder,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, payment_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentReminderResponse:
        """
        Parameters
        ----------
        payment_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentReminderResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_reminders.get_by_id(payment_reminder_id='payment_reminder_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(payment_reminder_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, payment_reminder_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        payment_reminder_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_reminders.delete_by_id(payment_reminder_id='payment_reminder_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(payment_reminder_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        payment_reminder_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        term1reminder: typing.Optional[Reminder] = OMIT,
        term2reminder: typing.Optional[Reminder] = OMIT,
        term_final_reminder: typing.Optional[Reminder] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentReminderResponse:
        """
        Parameters
        ----------
        payment_reminder_id : str

        name : typing.Optional[str]

        recipients : typing.Optional[Recipients]

        term1reminder : typing.Optional[Reminder]
            Reminder to send for first payment term

        term2reminder : typing.Optional[Reminder]
            Reminder to send for second payment term

        term_final_reminder : typing.Optional[Reminder]
            Reminder to send for final payment term

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentReminderResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_reminders.update_by_id(payment_reminder_id='payment_reminder_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            payment_reminder_id,
            name=name,
            recipients=recipients,
            term1reminder=term1reminder,
            term2reminder=term2reminder,
            term_final_reminder=term_final_reminder,
            request_options=request_options,
        )
        return _response.data
