# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.payment_term import PaymentTerm
from ..types.payment_term_discount import PaymentTermDiscount
from ..types.payment_terms_list_response import PaymentTermsListResponse
from ..types.payment_terms_response import PaymentTermsResponse
from .raw_client import AsyncRawPaymentTermsClient, RawPaymentTermsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PaymentTermsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPaymentTermsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPaymentTermsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPaymentTermsClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaymentTermsListResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_terms.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        term_final: PaymentTerm,
        description: typing.Optional[str] = OMIT,
        term1: typing.Optional[PaymentTermDiscount] = OMIT,
        term2: typing.Optional[PaymentTermDiscount] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentTermsResponse:
        """
        Parameters
        ----------
        name : str

        term_final : PaymentTerm
            The final tier of the payment term. Defines the invoice due date.

        description : typing.Optional[str]

        term1 : typing.Optional[PaymentTermDiscount]
            The first tier of the payment term. Represents the terms of the first early discount.

        term2 : typing.Optional[PaymentTermDiscount]
            The second tier of the payment term. Defines the terms of the second early discount.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import PaymentTerm
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_terms.create(name='name', term_final=PaymentTerm(number_of_days=1, ), )
        """
        _response = self._raw_client.create(
            name=name,
            term_final=term_final,
            description=description,
            term1=term1,
            term2=term2,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, payment_terms_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentTermsResponse:
        """
        Parameters
        ----------
        payment_terms_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_terms.get_by_id(payment_terms_id='payment_terms_id', )
        """
        _response = self._raw_client.get_by_id(payment_terms_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, payment_terms_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        payment_terms_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_terms.delete_by_id(payment_terms_id='payment_terms_id', )
        """
        _response = self._raw_client.delete_by_id(payment_terms_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        payment_terms_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        term1: typing.Optional[PaymentTermDiscount] = OMIT,
        term2: typing.Optional[PaymentTermDiscount] = OMIT,
        term_final: typing.Optional[PaymentTerm] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentTermsResponse:
        """
        Parameters
        ----------
        payment_terms_id : str

        description : typing.Optional[str]

        name : typing.Optional[str]

        term1 : typing.Optional[PaymentTermDiscount]
            The first tier of the payment term. Represents the terms of the first early discount.

        term2 : typing.Optional[PaymentTermDiscount]
            The second tier of the payment term. Defines the terms of the second early discount.

        term_final : typing.Optional[PaymentTerm]
            The final tier of the payment term. Defines the invoice due date.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.payment_terms.update_by_id(payment_terms_id='payment_terms_id', )
        """
        _response = self._raw_client.update_by_id(
            payment_terms_id,
            description=description,
            name=name,
            term1=term1,
            term2=term2,
            term_final=term_final,
            request_options=request_options,
        )
        return _response.data


class AsyncPaymentTermsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPaymentTermsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPaymentTermsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPaymentTermsClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaymentTermsListResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_terms.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        term_final: PaymentTerm,
        description: typing.Optional[str] = OMIT,
        term1: typing.Optional[PaymentTermDiscount] = OMIT,
        term2: typing.Optional[PaymentTermDiscount] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentTermsResponse:
        """
        Parameters
        ----------
        name : str

        term_final : PaymentTerm
            The final tier of the payment term. Defines the invoice due date.

        description : typing.Optional[str]

        term1 : typing.Optional[PaymentTermDiscount]
            The first tier of the payment term. Represents the terms of the first early discount.

        term2 : typing.Optional[PaymentTermDiscount]
            The second tier of the payment term. Defines the terms of the second early discount.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import PaymentTerm
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_terms.create(name='name', term_final=PaymentTerm(number_of_days=1, ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            term_final=term_final,
            description=description,
            term1=term1,
            term2=term2,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, payment_terms_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaymentTermsResponse:
        """
        Parameters
        ----------
        payment_terms_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_terms.get_by_id(payment_terms_id='payment_terms_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(payment_terms_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, payment_terms_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        payment_terms_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_terms.delete_by_id(payment_terms_id='payment_terms_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(payment_terms_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        payment_terms_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        term1: typing.Optional[PaymentTermDiscount] = OMIT,
        term2: typing.Optional[PaymentTermDiscount] = OMIT,
        term_final: typing.Optional[PaymentTerm] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaymentTermsResponse:
        """
        Parameters
        ----------
        payment_terms_id : str

        description : typing.Optional[str]

        name : typing.Optional[str]

        term1 : typing.Optional[PaymentTermDiscount]
            The first tier of the payment term. Represents the terms of the first early discount.

        term2 : typing.Optional[PaymentTermDiscount]
            The second tier of the payment term. Defines the terms of the second early discount.

        term_final : typing.Optional[PaymentTerm]
            The final tier of the payment term. Defines the invoice due date.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaymentTermsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.payment_terms.update_by_id(payment_terms_id='payment_terms_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            payment_terms_id,
            description=description,
            name=name,
            term1=term1,
            term2=term2,
            term_final=term_final,
            request_options=request_options,
        )
        return _response.data
