# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.template_list_response import TemplateListResponse
from ..types.template_receivable_response import TemplateReceivableResponse
from .raw_client import AsyncRawPdfTemplatesClient, RawPdfTemplatesClient


class PdfTemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPdfTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPdfTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPdfTemplatesClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> TemplateListResponse:
        """
        This API call returns all supported templates with language codes.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.pdf_templates.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def get_system(self, *, request_options: typing.Optional[RequestOptions] = None) -> TemplateListResponse:
        """
        This API call returns all supported system templates with language codes.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateListResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.pdf_templates.get_system()
        """
        _response = self._raw_client.get_system(request_options=request_options)
        return _response.data

    def get_by_id(
        self, document_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplateReceivableResponse:
        """
        Parameters
        ----------
        document_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.pdf_templates.get_by_id(document_template_id='document_template_id', )
        """
        _response = self._raw_client.get_by_id(document_template_id, request_options=request_options)
        return _response.data

    def make_default_by_id(
        self, document_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplateReceivableResponse:
        """
        Parameters
        ----------
        document_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.pdf_templates.make_default_by_id(document_template_id='document_template_id', )
        """
        _response = self._raw_client.make_default_by_id(document_template_id, request_options=request_options)
        return _response.data

    def preview_by_id(
        self, document_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[bytes]:
        """
        Returns a sample PDF invoice generated using the specified template.

        Parameters
        ----------
        document_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[bytes]
            Successful Response
        """
        with self._raw_client.preview_by_id(document_template_id, request_options=request_options) as r:
            yield from r.data


class AsyncPdfTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPdfTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPdfTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPdfTemplatesClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> TemplateListResponse:
        """
        This API call returns all supported templates with language codes.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.pdf_templates.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def get_system(self, *, request_options: typing.Optional[RequestOptions] = None) -> TemplateListResponse:
        """
        This API call returns all supported system templates with language codes.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateListResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.pdf_templates.get_system()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_system(request_options=request_options)
        return _response.data

    async def get_by_id(
        self, document_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplateReceivableResponse:
        """
        Parameters
        ----------
        document_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.pdf_templates.get_by_id(document_template_id='document_template_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(document_template_id, request_options=request_options)
        return _response.data

    async def make_default_by_id(
        self, document_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TemplateReceivableResponse:
        """
        Parameters
        ----------
        document_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TemplateReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.pdf_templates.make_default_by_id(document_template_id='document_template_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.make_default_by_id(document_template_id, request_options=request_options)
        return _response.data

    async def preview_by_id(
        self, document_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[bytes]:
        """
        Returns a sample PDF invoice generated using the specified template.

        Parameters
        ----------
        document_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[bytes]
            Successful Response
        """
        async with self._raw_client.preview_by_id(document_template_id, request_options=request_options) as r:
            async for data in r.data:
                yield data
