# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.currency_enum import CurrencyEnum
from ..types.order_enum import OrderEnum
from ..types.price import Price
from ..types.product_cursor_fields import ProductCursorFields
from ..types.product_service_pagination_response import ProductServicePaginationResponse
from ..types.product_service_response import ProductServiceResponse
from ..types.product_service_type_enum import ProductServiceTypeEnum
from .raw_client import AsyncRawProductsClient, RawProductsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProductsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProductsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProductsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProductsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ProductCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        type: typing.Optional[ProductServiceTypeEnum] = None,
        price: typing.Optional[int] = None,
        price_gt: typing.Optional[int] = None,
        price_lt: typing.Optional[int] = None,
        price_gte: typing.Optional[int] = None,
        price_lte: typing.Optional[int] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        currency_in: typing.Optional[typing.Union[CurrencyEnum, typing.Sequence[CurrencyEnum]]] = None,
        measure_unit_id: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProductServicePaginationResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ProductCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        type : typing.Optional[ProductServiceTypeEnum]

        price : typing.Optional[int]

        price_gt : typing.Optional[int]

        price_lt : typing.Optional[int]

        price_gte : typing.Optional[int]

        price_lte : typing.Optional[int]

        currency : typing.Optional[CurrencyEnum]

        currency_in : typing.Optional[typing.Union[CurrencyEnum, typing.Sequence[CurrencyEnum]]]

        measure_unit_id : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServicePaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.products.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            name=name,
            name_contains=name_contains,
            name_icontains=name_icontains,
            type=type,
            price=price,
            price_gt=price_gt,
            price_lt=price_lt,
            price_gte=price_gte,
            price_lte=price_lte,
            currency=currency,
            currency_in=currency_in,
            measure_unit_id=measure_unit_id,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        ledger_account_id: typing.Optional[str] = OMIT,
        measure_unit_id: typing.Optional[str] = OMIT,
        price: typing.Optional[Price] = OMIT,
        smallest_amount: typing.Optional[float] = OMIT,
        type: typing.Optional[ProductServiceTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProductServiceResponse:
        """
        Parameters
        ----------
        name : str
            Name of the product.

        description : typing.Optional[str]
            Description of the product.

        ledger_account_id : typing.Optional[str]

        measure_unit_id : typing.Optional[str]
            The unique ID reference of the unit used to measure the quantity of this product (e.g. items, meters, kilograms).

        price : typing.Optional[Price]

        smallest_amount : typing.Optional[float]
            The smallest amount allowed for this product.

        type : typing.Optional[ProductServiceTypeEnum]
            Specifies whether this offering is a product or service. This may affect the applicable tax rates.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServiceResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.products.create(name='name', )
        """
        _response = self._raw_client.create(
            name=name,
            description=description,
            ledger_account_id=ledger_account_id,
            measure_unit_id=measure_unit_id,
            price=price,
            smallest_amount=smallest_amount,
            type=type,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(
        self, product_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProductServiceResponse:
        """
        Parameters
        ----------
        product_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServiceResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.products.get_by_id(product_id='product_id', )
        """
        _response = self._raw_client.get_by_id(product_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, product_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        product_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.products.delete_by_id(product_id='product_id', )
        """
        _response = self._raw_client.delete_by_id(product_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        product_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        ledger_account_id: typing.Optional[str] = OMIT,
        measure_unit_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        price: typing.Optional[Price] = OMIT,
        smallest_amount: typing.Optional[float] = OMIT,
        type: typing.Optional[ProductServiceTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProductServiceResponse:
        """
        Parameters
        ----------
        product_id : str

        description : typing.Optional[str]
            Description of the product.

        ledger_account_id : typing.Optional[str]

        measure_unit_id : typing.Optional[str]
            The unique ID reference of the unit used to measure the quantity of this product (e.g. items, meters, kilograms).

        name : typing.Optional[str]
            Name of the product.

        price : typing.Optional[Price]

        smallest_amount : typing.Optional[float]
            The smallest amount allowed for this product.

        type : typing.Optional[ProductServiceTypeEnum]
            Specifies whether this offering is a product or service. This may affect the applicable tax rates.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServiceResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.products.update_by_id(product_id='product_id', )
        """
        _response = self._raw_client.update_by_id(
            product_id,
            description=description,
            ledger_account_id=ledger_account_id,
            measure_unit_id=measure_unit_id,
            name=name,
            price=price,
            smallest_amount=smallest_amount,
            type=type,
            request_options=request_options,
        )
        return _response.data


class AsyncProductsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProductsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProductsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProductsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ProductCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        type: typing.Optional[ProductServiceTypeEnum] = None,
        price: typing.Optional[int] = None,
        price_gt: typing.Optional[int] = None,
        price_lt: typing.Optional[int] = None,
        price_gte: typing.Optional[int] = None,
        price_lte: typing.Optional[int] = None,
        currency: typing.Optional[CurrencyEnum] = None,
        currency_in: typing.Optional[typing.Union[CurrencyEnum, typing.Sequence[CurrencyEnum]]] = None,
        measure_unit_id: typing.Optional[str] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProductServicePaginationResponse:
        """
        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ProductCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        type : typing.Optional[ProductServiceTypeEnum]

        price : typing.Optional[int]

        price_gt : typing.Optional[int]

        price_lt : typing.Optional[int]

        price_gte : typing.Optional[int]

        price_lte : typing.Optional[int]

        currency : typing.Optional[CurrencyEnum]

        currency_in : typing.Optional[typing.Union[CurrencyEnum, typing.Sequence[CurrencyEnum]]]

        measure_unit_id : typing.Optional[str]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServicePaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.products.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            name=name,
            name_contains=name_contains,
            name_icontains=name_icontains,
            type=type,
            price=price,
            price_gt=price_gt,
            price_lt=price_lt,
            price_gte=price_gte,
            price_lte=price_lte,
            currency=currency,
            currency_in=currency_in,
            measure_unit_id=measure_unit_id,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        ledger_account_id: typing.Optional[str] = OMIT,
        measure_unit_id: typing.Optional[str] = OMIT,
        price: typing.Optional[Price] = OMIT,
        smallest_amount: typing.Optional[float] = OMIT,
        type: typing.Optional[ProductServiceTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProductServiceResponse:
        """
        Parameters
        ----------
        name : str
            Name of the product.

        description : typing.Optional[str]
            Description of the product.

        ledger_account_id : typing.Optional[str]

        measure_unit_id : typing.Optional[str]
            The unique ID reference of the unit used to measure the quantity of this product (e.g. items, meters, kilograms).

        price : typing.Optional[Price]

        smallest_amount : typing.Optional[float]
            The smallest amount allowed for this product.

        type : typing.Optional[ProductServiceTypeEnum]
            Specifies whether this offering is a product or service. This may affect the applicable tax rates.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServiceResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.products.create(name='name', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            description=description,
            ledger_account_id=ledger_account_id,
            measure_unit_id=measure_unit_id,
            price=price,
            smallest_amount=smallest_amount,
            type=type,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, product_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProductServiceResponse:
        """
        Parameters
        ----------
        product_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServiceResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.products.get_by_id(product_id='product_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(product_id, request_options=request_options)
        return _response.data

    async def delete_by_id(self, product_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        product_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.products.delete_by_id(product_id='product_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(product_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        product_id: str,
        *,
        description: typing.Optional[str] = OMIT,
        ledger_account_id: typing.Optional[str] = OMIT,
        measure_unit_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        price: typing.Optional[Price] = OMIT,
        smallest_amount: typing.Optional[float] = OMIT,
        type: typing.Optional[ProductServiceTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProductServiceResponse:
        """
        Parameters
        ----------
        product_id : str

        description : typing.Optional[str]
            Description of the product.

        ledger_account_id : typing.Optional[str]

        measure_unit_id : typing.Optional[str]
            The unique ID reference of the unit used to measure the quantity of this product (e.g. items, meters, kilograms).

        name : typing.Optional[str]
            Name of the product.

        price : typing.Optional[Price]

        smallest_amount : typing.Optional[float]
            The smallest amount allowed for this product.

        type : typing.Optional[ProductServiceTypeEnum]
            Specifies whether this offering is a product or service. This may affect the applicable tax rates.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProductServiceResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.products.update_by_id(product_id='product_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            product_id,
            description=description,
            ledger_account_id=ledger_account_id,
            measure_unit_id=measure_unit_id,
            name=name,
            price=price,
            smallest_amount=smallest_amount,
            type=type,
            request_options=request_options,
        )
        return _response.data
