# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.order_enum import OrderEnum
from ..types.project_cursor_fields import ProjectCursorFields
from ..types.project_pagination_response import ProjectPaginationResponse
from ..types.project_resource import ProjectResource
from .raw_client import AsyncRawProjectsClient, RawProjectsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ProjectsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProjectsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ProjectCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        start_date: typing.Optional[str] = None,
        start_date_gt: typing.Optional[str] = None,
        start_date_lt: typing.Optional[str] = None,
        start_date_gte: typing.Optional[str] = None,
        start_date_lte: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        end_date_gt: typing.Optional[str] = None,
        end_date_lt: typing.Optional[str] = None,
        end_date_gte: typing.Optional[str] = None,
        end_date_lte: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        name_iexact: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        code: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectPaginationResponse:
        """
        Get all projects for an entity

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ProjectCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        start_date : typing.Optional[str]

        start_date_gt : typing.Optional[str]

        start_date_lt : typing.Optional[str]

        start_date_gte : typing.Optional[str]

        start_date_lte : typing.Optional[str]

        end_date : typing.Optional[str]

        end_date_gt : typing.Optional[str]

        end_date_lt : typing.Optional[str]

        end_date_gte : typing.Optional[str]

        end_date_lte : typing.Optional[str]

        name : typing.Optional[str]

        name_iexact : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        code : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.projects.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            start_date=start_date,
            start_date_gt=start_date_gt,
            start_date_lt=start_date_lt,
            start_date_gte=start_date_gte,
            start_date_lte=start_date_lte,
            end_date=end_date,
            end_date_gt=end_date_gt,
            end_date_lt=end_date_lt,
            end_date_gte=end_date_gte,
            end_date_lte=end_date_lte,
            name=name,
            name_iexact=name_iexact,
            name_contains=name_contains,
            name_icontains=name_icontains,
            code=code,
            created_by_entity_user_id=created_by_entity_user_id,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        name: str,
        code: typing.Optional[str] = OMIT,
        color: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        end_date: typing.Optional[str] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        start_date: typing.Optional[str] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectResource:
        """
        Create a new project.

        Parameters
        ----------
        name : str
            The project name.

        code : typing.Optional[str]
            Project code

        color : typing.Optional[str]
            Project color

        description : typing.Optional[str]
            Description of project

        end_date : typing.Optional[str]
            Project end date

        parent_id : typing.Optional[str]
            Parent project ID

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Project metadata

        start_date : typing.Optional[str]
            Project start date

        tag_ids : typing.Optional[typing.Sequence[str]]
            A list of IDs of user-defined tags (labels) assigned to this project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.projects.create(name='Marketing', )
        """
        _response = self._raw_client.create(
            name=name,
            code=code,
            color=color,
            description=description,
            end_date=end_date,
            parent_id=parent_id,
            partner_metadata=partner_metadata,
            start_date=start_date,
            tag_ids=tag_ids,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ProjectResource:
        """
        Get a project with the given ID.

        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.projects.get_by_id(project_id='project_id', )
        """
        _response = self._raw_client.get_by_id(project_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a project.

        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.projects.delete_by_id(project_id='project_id', )
        """
        _response = self._raw_client.delete_by_id(project_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        project_id: str,
        *,
        code: typing.Optional[str] = OMIT,
        color: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        end_date: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        start_date: typing.Optional[str] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectResource:
        """
        Update a project.

        Parameters
        ----------
        project_id : str

        code : typing.Optional[str]
            Project code

        color : typing.Optional[str]
            Project color

        description : typing.Optional[str]
            Description of project

        end_date : typing.Optional[str]
            Project end date

        name : typing.Optional[str]
            The project name.

        parent_id : typing.Optional[str]
            Parent project ID

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Project metadata

        start_date : typing.Optional[str]
            Project start date

        tag_ids : typing.Optional[typing.Sequence[str]]
            A list of IDs of user-defined tags (labels) assigned to this project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectResource
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.projects.update_by_id(project_id='project_id', )
        """
        _response = self._raw_client.update_by_id(
            project_id,
            code=code,
            color=color,
            description=description,
            end_date=end_date,
            name=name,
            parent_id=parent_id,
            partner_metadata=partner_metadata,
            start_date=start_date,
            tag_ids=tag_ids,
            request_options=request_options,
        )
        return _response.data


class AsyncProjectsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProjectsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ProjectCursorFields] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        start_date: typing.Optional[str] = None,
        start_date_gt: typing.Optional[str] = None,
        start_date_lt: typing.Optional[str] = None,
        start_date_gte: typing.Optional[str] = None,
        start_date_lte: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        end_date_gt: typing.Optional[str] = None,
        end_date_lt: typing.Optional[str] = None,
        end_date_gte: typing.Optional[str] = None,
        end_date_lte: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        name_iexact: typing.Optional[str] = None,
        name_contains: typing.Optional[str] = None,
        name_icontains: typing.Optional[str] = None,
        code: typing.Optional[str] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectPaginationResponse:
        """
        Get all projects for an entity

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ProjectCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        start_date : typing.Optional[str]

        start_date_gt : typing.Optional[str]

        start_date_lt : typing.Optional[str]

        start_date_gte : typing.Optional[str]

        start_date_lte : typing.Optional[str]

        end_date : typing.Optional[str]

        end_date_gt : typing.Optional[str]

        end_date_lt : typing.Optional[str]

        end_date_gte : typing.Optional[str]

        end_date_lte : typing.Optional[str]

        name : typing.Optional[str]

        name_iexact : typing.Optional[str]

        name_contains : typing.Optional[str]

        name_icontains : typing.Optional[str]

        code : typing.Optional[str]

        created_by_entity_user_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.projects.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            start_date=start_date,
            start_date_gt=start_date_gt,
            start_date_lt=start_date_lt,
            start_date_gte=start_date_gte,
            start_date_lte=start_date_lte,
            end_date=end_date,
            end_date_gt=end_date_gt,
            end_date_lt=end_date_lt,
            end_date_gte=end_date_gte,
            end_date_lte=end_date_lte,
            name=name,
            name_iexact=name_iexact,
            name_contains=name_contains,
            name_icontains=name_icontains,
            code=code,
            created_by_entity_user_id=created_by_entity_user_id,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        name: str,
        code: typing.Optional[str] = OMIT,
        color: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        end_date: typing.Optional[str] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        start_date: typing.Optional[str] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectResource:
        """
        Create a new project.

        Parameters
        ----------
        name : str
            The project name.

        code : typing.Optional[str]
            Project code

        color : typing.Optional[str]
            Project color

        description : typing.Optional[str]
            Description of project

        end_date : typing.Optional[str]
            Project end date

        parent_id : typing.Optional[str]
            Parent project ID

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Project metadata

        start_date : typing.Optional[str]
            Project start date

        tag_ids : typing.Optional[typing.Sequence[str]]
            A list of IDs of user-defined tags (labels) assigned to this project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.projects.create(name='Marketing', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            code=code,
            color=color,
            description=description,
            end_date=end_date,
            parent_id=parent_id,
            partner_metadata=partner_metadata,
            start_date=start_date,
            tag_ids=tag_ids,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ProjectResource:
        """
        Get a project with the given ID.

        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.projects.get_by_id(project_id='project_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(project_id, request_options=request_options)
        return _response.data

    async def delete_by_id(self, project_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a project.

        Parameters
        ----------
        project_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.projects.delete_by_id(project_id='project_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(project_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        project_id: str,
        *,
        code: typing.Optional[str] = OMIT,
        color: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        end_date: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        start_date: typing.Optional[str] = OMIT,
        tag_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ProjectResource:
        """
        Update a project.

        Parameters
        ----------
        project_id : str

        code : typing.Optional[str]
            Project code

        color : typing.Optional[str]
            Project color

        description : typing.Optional[str]
            Description of project

        end_date : typing.Optional[str]
            Project end date

        name : typing.Optional[str]
            The project name.

        parent_id : typing.Optional[str]
            Parent project ID

        partner_metadata : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Project metadata

        start_date : typing.Optional[str]
            Project start date

        tag_ids : typing.Optional[typing.Sequence[str]]
            A list of IDs of user-defined tags (labels) assigned to this project.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ProjectResource
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.projects.update_by_id(project_id='project_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            project_id,
            code=code,
            color=color,
            description=description,
            end_date=end_date,
            name=name,
            parent_id=parent_id,
            partner_metadata=partner_metadata,
            start_date=start_date,
            tag_ids=tag_ids,
            request_options=request_options,
        )
        return _response.data
