# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.allowed_countries import AllowedCountries
from ..types.counterpart_type import CounterpartType
from ..types.language_code_enum import LanguageCodeEnum
from ..types.line_item import LineItem
from ..types.line_items_response import LineItemsResponse
from ..types.order_enum import OrderEnum
from ..types.receivable_cursor_fields import ReceivableCursorFields
from ..types.receivable_facade_create_payload import ReceivableFacadeCreatePayload
from ..types.receivable_file_url import ReceivableFileUrl
from ..types.receivable_history_cursor_fields import ReceivableHistoryCursorFields
from ..types.receivable_history_event_type_enum import ReceivableHistoryEventTypeEnum
from ..types.receivable_history_pagination_response import ReceivableHistoryPaginationResponse
from ..types.receivable_history_response import ReceivableHistoryResponse
from ..types.receivable_mail_cursor_fields import ReceivableMailCursorFields
from ..types.receivable_mail_pagination_response import ReceivableMailPaginationResponse
from ..types.receivable_mail_response import ReceivableMailResponse
from ..types.receivable_mail_status_enum import ReceivableMailStatusEnum
from ..types.receivable_pagination_response import ReceivablePaginationResponse
from ..types.receivable_preview_response import ReceivablePreviewResponse
from ..types.receivable_required_fields import ReceivableRequiredFields
from ..types.receivable_response import ReceivableResponse
from ..types.receivable_send_response import ReceivableSendResponse
from ..types.receivable_templates_variables_object_list import ReceivableTemplatesVariablesObjectList
from ..types.receivable_type import ReceivableType
from ..types.receivable_update_payload import ReceivableUpdatePayload
from ..types.receivables_preview_type_enum import ReceivablesPreviewTypeEnum
from ..types.receivables_send_response import ReceivablesSendResponse
from ..types.receivables_verify_response import ReceivablesVerifyResponse
from ..types.recipients import Recipients
from ..types.reminder_type_enum import ReminderTypeEnum
from ..types.signature import Signature
from ..types.success_result import SuccessResult
from .raw_client import AsyncRawReceivablesClient, RawReceivablesClient
from .types.receivables_get_request_status import ReceivablesGetRequestStatus
from .types.receivables_get_request_status_in_item import ReceivablesGetRequestStatusInItem

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ReceivablesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawReceivablesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawReceivablesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawReceivablesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status_in: typing.Optional[
            typing.Union[ReceivablesGetRequestStatusInItem, typing.Sequence[ReceivablesGetRequestStatusInItem]]
        ] = None,
        entity_user_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        sort: typing.Optional[ReceivableCursorFields] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        type: typing.Optional[ReceivableType] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        issue_date_gt: typing.Optional[dt.datetime] = None,
        issue_date_lt: typing.Optional[dt.datetime] = None,
        issue_date_gte: typing.Optional[dt.datetime] = None,
        issue_date_lte: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        counterpart_id: typing.Optional[str] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        status: typing.Optional[ReceivablesGetRequestStatus] = None,
        entity_user_id: typing.Optional[str] = None,
        based_on: typing.Optional[str] = None,
        due_date_gt: typing.Optional[str] = None,
        due_date_lt: typing.Optional[str] = None,
        due_date_gte: typing.Optional[str] = None,
        due_date_lte: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablePaginationResponse:
        """
        Returns a list of [accounts receivable](https://docs.monite.com/accounts-receivable/index) documents - invoices, quotes, and credit notes - of the specified entity.

        Results can be filtered by amount, counterpart, due date, and other criteria. Multiple filters are combined using logical AND unless specified otherwise. If no documents matching the search criteria are found, the endpoint returns a successful response with an empty `data` array.

        This endpoint supports [pagination](https://docs.monite.com/api/concepts/pagination-sorting-filtering) and sorting. By default, results are sorted by the creation date in ascending order (from oldest to newest).

        #### Examples

        ##### Invoices

        * Get all overdue invoices:
            ```
            GET /receivables?type=invoice&status=overdue
            ```

        * Get all invoices created for the counterpart named "Solarwind" (case-insensitive):

            ```
            GET /receivables?type=invoice?counterpart_name__icontains=Solarwind
            ```

        * Get invoices whose total amount starts from 500 EUR:

            ```
            GET /receivables?type=invoice&total_amount__gte=50000
            ```

        * Get invoices that are due for payment in September 2024:

            ```
            GET /receivables?type=invoice&due_date__gte=2024-09-01T00:00:00Z&due_date__lt=2024-10-01T00:00:00Z
            ```

        * Get invoices created on or after September 1, 2024:

            ```
            GET /receivables?type=invoice&created_at__gte=2024-09-01T00:00:00Z
            ```

        * Find an invoice created from a specific quote:

            ```
            GET /receivables?type=invoice?based_on=QUOTE_ID
            ```

        ##### Quotes

        * Get the latest created quote:

            ```
            GET /receivables?type=quote&sort=created_at&order=desc&limit=1
            ```

        * Get the latest issued quote:

            ```
            GET /receivables?type=quote&sort=issue_date&order=desc&limit=1
            ```

        ##### Credit notes

        * Find all credit notes created for a specific invoice:

            ```
            GET /receivables?type=credit_note?based_on=INVOICE_ID
            ```

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 250) to return in a single page of the response. Default is 100. The response may contain fewer items if it is the last or only page.

            When using pagination with a non-default `limit`, you must provide the `limit` value alongside `pagination_token` in all subsequent pagination requests. Unlike other query parameters, `limit` is not inferred from `pagination_token`.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters except `limit` are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables with the specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value:
            `id__in=<id1>&id__in=<id2>`

        status_in : typing.Optional[typing.Union[ReceivablesGetRequestStatusInItem, typing.Sequence[ReceivablesGetRequestStatusInItem]]]
            Return only receivables that have the specified statuses. See the applicable [invoice statuses](https://docs.monite.com/accounts-receivable/invoices/index), [quote statuses](https://docs.monite.com/accounts-receivable/quotes/index), and [credit note statuses](https://docs.monite.com/accounts-receivable/credit-notes#credit-note-lifecycle).

            To specify multiple statuses, repeat this parameter for each value:
            `status__in=draft&status__in=issued`

        entity_user_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables created by the entity users with the specified IDs.To specify multiple user IDs, repeat this parameter for each ID:
            `entity_user_id__in=<user1>&entity_user_id__in=<user2>`

            If the request is authenticated using an entity user token, this user must have the `receivable.read.allowed` (rather than `allowed_for_own`) permission to be able to query receivables created by other users.

            IDs of deleted users will still produce results here if those users had associated receivables. Valid but nonexistent user IDs do not raise errors but produce no results.

        sort : typing.Optional[ReceivableCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include at least one of the tags with the specified IDs.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagB, tagC


            `tag_ids__in=<tagA>&tag_ids__in=<tagB>` will return receivables 1, 2, 3, and 5.

            Valid but nonexistent tag IDs do not raise errors but produce no results.

        tag_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include all of the tags with the specified IDs and optionally other tags that are not specified.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagA, tagB, tagC


            `tag_ids=<tagA>&tag_ids=<tagB>` will return receivables 3 and 5.

        product_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include at least one of the product IDs with the specified IDs.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids__in=<product1>&product_ids__in=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productB, productC


            `product_ids__in=<productA>&product_ids__in=<productB>` will return receivables 1, 2, 3, and 5.Valid but nonexistent product IDs do not raise errors but produce no results.

        product_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include all of the product IDs with the specified IDs and optionally other products that are not specified.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids=<product1>&product_ids=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productA, productB, productC


            `product_ids=<productA>&product_ids=<productB>` will return receivables 3 and 5.

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose `project_id` include at least one of the project_id with the specified IDs. Valid but nonexistent project IDs do not raise errors but produce no results.

        type : typing.Optional[ReceivableType]

        document_id : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        issue_date_gt : typing.Optional[dt.datetime]

        issue_date_lt : typing.Optional[dt.datetime]

        issue_date_gte : typing.Optional[dt.datetime]

        issue_date_lte : typing.Optional[dt.datetime]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        counterpart_id : typing.Optional[str]

        counterpart_name : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        total_amount : typing.Optional[int]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        status : typing.Optional[ReceivablesGetRequestStatus]

        entity_user_id : typing.Optional[str]

        based_on : typing.Optional[str]

        due_date_gt : typing.Optional[str]

        due_date_lt : typing.Optional[str]

        due_date_gte : typing.Optional[str]

        due_date_lte : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablePaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            id_in=id_in,
            status_in=status_in,
            entity_user_id_in=entity_user_id_in,
            sort=sort,
            tag_ids_in=tag_ids_in,
            tag_ids=tag_ids,
            product_ids_in=product_ids_in,
            product_ids=product_ids,
            project_id_in=project_id_in,
            type=type,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            issue_date_gt=issue_date_gt,
            issue_date_lt=issue_date_lt,
            issue_date_gte=issue_date_gte,
            issue_date_lte=issue_date_lte,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            counterpart_id=counterpart_id,
            counterpart_name=counterpart_name,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            total_amount=total_amount,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            status=status,
            entity_user_id=entity_user_id,
            based_on=based_on,
            due_date_gt=due_date_gt,
            due_date_lt=due_date_lt,
            due_date_gte=due_date_gte,
            due_date_lte=due_date_lte,
            project_id=project_id,
            request_options=request_options,
        )
        return _response.data

    def create(
        self, *, request: ReceivableFacadeCreatePayload, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        request : ReceivableFacadeCreatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import ReceivableFacadeCreateQuotePayload
        from monite import LineItem
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.create(request=ReceivableFacadeCreateQuotePayload(counterpart_billing_address_id='counterpart_billing_address_id', counterpart_id='counterpart_id', currency="AED", line_items=[LineItem(quantity=1.1, )], ), )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def get_receivables_required_fields(
        self,
        *,
        counterpart_id: typing.Optional[str] = None,
        counterpart_billing_address_id: typing.Optional[str] = None,
        counterpart_country: typing.Optional[AllowedCountries] = None,
        counterpart_type: typing.Optional[CounterpartType] = None,
        entity_vat_id_id: typing.Optional[str] = None,
        counterpart_vat_id_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableRequiredFields:
        """
        Get field requirements for invoice creation given the entity and counterpart details.

        Parameters
        ----------
        counterpart_id : typing.Optional[str]

        counterpart_billing_address_id : typing.Optional[str]

        counterpart_country : typing.Optional[AllowedCountries]

        counterpart_type : typing.Optional[CounterpartType]

        entity_vat_id_id : typing.Optional[str]

        counterpart_vat_id_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableRequiredFields
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_receivables_required_fields()
        """
        _response = self._raw_client.get_receivables_required_fields(
            counterpart_id=counterpart_id,
            counterpart_billing_address_id=counterpart_billing_address_id,
            counterpart_country=counterpart_country,
            counterpart_type=counterpart_type,
            entity_vat_id_id=entity_vat_id_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            request_options=request_options,
        )
        return _response.data

    def get_variables(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableTemplatesVariablesObjectList:
        """
        Get a list of placeholders that can be used in email templates for customization.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableTemplatesVariablesObjectList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_variables()
        """
        _response = self._raw_client.get_variables(request_options=request_options)
        return _response.data

    def get_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.get_by_id(receivable_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.delete_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.delete_by_id(receivable_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        receivable_id: str,
        *,
        request: ReceivableUpdatePayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request : ReceivableUpdatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import UpdateQuotePayload
        from monite import UpdateQuote
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.update_by_id(receivable_id='receivable_id', request=UpdateQuotePayload(quote=UpdateQuote(), ), )
        """
        _response = self._raw_client.update_by_id(receivable_id, request=request, request_options=request_options)
        return _response.data

    def accept_by_id(
        self,
        receivable_id: str,
        *,
        signature: typing.Optional[Signature] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResult:
        """
        Parameters
        ----------
        receivable_id : str

        signature : typing.Optional[Signature]
            A digital signature, if required for quote acceptance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResult
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.accept_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.accept_by_id(receivable_id, signature=signature, request_options=request_options)
        return _response.data

    def cancel_by_id(self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.cancel_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.cancel_by_id(receivable_id, request_options=request_options)
        return _response.data

    def clone_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.clone_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.clone_by_id(receivable_id, request_options=request_options)
        return _response.data

    def decline_by_id(
        self,
        receivable_id: str,
        *,
        comment: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResult:
        """
        Parameters
        ----------
        receivable_id : str

        comment : typing.Optional[str]
            Field with a comment on why the client declined this Quote

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResult
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.decline_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.decline_by_id(receivable_id, comment=comment, request_options=request_options)
        return _response.data

    def get_history(
        self,
        receivable_id: str,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ReceivableHistoryCursorFields] = None,
        event_type_in: typing.Optional[
            typing.Union[ReceivableHistoryEventTypeEnum, typing.Sequence[ReceivableHistoryEventTypeEnum]]
        ] = None,
        entity_user_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        timestamp_gt: typing.Optional[dt.datetime] = None,
        timestamp_lt: typing.Optional[dt.datetime] = None,
        timestamp_gte: typing.Optional[dt.datetime] = None,
        timestamp_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableHistoryPaginationResponse:
        """
        Returns the history of the specified accounts receivable document. The history contains all revisions of the document, status updates, and other events that occurred during the document's lifecycle. For more information, see [Document history](https://docs.monite.com/accounts-receivable/document-history).

        You can filter the history by the date range and event type. Events are sorted from oldest to newest by default.

        Parameters
        ----------
        receivable_id : str
            ID of the accounts receivable document whose history you want to get.

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ReceivableHistoryCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        event_type_in : typing.Optional[typing.Union[ReceivableHistoryEventTypeEnum, typing.Sequence[ReceivableHistoryEventTypeEnum]]]
            Return only the specified [event types](https://docs.monite.com/accounts-receivable/document-history#event-types). To include multiple types, repeat this parameter for each value:
            `event_type__in=receivable_updated&event_type__in=status_changed`

        entity_user_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only events caused by the entity users with the specified IDs. To specify multiple user IDs, repeat this parameter for each ID:
            `entity_user_id__in=<user1>&entity_user_id__in=<user2>`

        timestamp_gt : typing.Optional[dt.datetime]
            Return only events that occurred after the specified date and time. The value must be in the ISO 8601 format `YYYY-MM-DDThh:mm[:ss[.ffffff]][Z|±hh:mm]`.

        timestamp_lt : typing.Optional[dt.datetime]
            Return only events that occurred before the specified date and time.

        timestamp_gte : typing.Optional[dt.datetime]
            Return only events that occurred on or after the specified date and time.

        timestamp_lte : typing.Optional[dt.datetime]
            Return only events that occurred before or on the specified date and time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableHistoryPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_history(receivable_id='receivable_id', )
        """
        _response = self._raw_client.get_history(
            receivable_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            event_type_in=event_type_in,
            entity_user_id_in=entity_user_id_in,
            timestamp_gt=timestamp_gt,
            timestamp_lt=timestamp_lt,
            timestamp_gte=timestamp_gte,
            timestamp_lte=timestamp_lte,
            request_options=request_options,
        )
        return _response.data

    def get_history_by_id(
        self, receivable_history_id: str, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableHistoryResponse:
        """
        Returns a single record from the change history of the specified accounts receivable document.

        Parameters
        ----------
        receivable_history_id : str
            ID of the history record to return. You can get these IDs from `GET /receivables/{receivable_id}/history`.

        receivable_id : str
            ID of the accounts receivable document whose history you want to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableHistoryResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_history_by_id(receivable_history_id='receivable_history_id', receivable_id='receivable_id', )
        """
        _response = self._raw_client.get_history_by_id(
            receivable_history_id, receivable_id, request_options=request_options
        )
        return _response.data

    def issue_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.issue_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.issue_by_id(receivable_id, request_options=request_options)
        return _response.data

    def update_line_items_by_id(
        self,
        receivable_id: str,
        *,
        data: typing.Sequence[LineItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LineItemsResponse:
        """
        Replace all line items of an existing invoice or quote with a new list of line items.

        Parameters
        ----------
        receivable_id : str

        data : typing.Sequence[LineItem]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LineItemsResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import LineItem
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.update_line_items_by_id(receivable_id='receivable_id', data=[LineItem(quantity=1.1, )], )
        """
        _response = self._raw_client.update_line_items_by_id(receivable_id, data=data, request_options=request_options)
        return _response.data

    def get_mails(
        self,
        receivable_id: str,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ReceivableMailCursorFields] = None,
        status: typing.Optional[ReceivableMailStatusEnum] = None,
        status_in: typing.Optional[
            typing.Union[ReceivableMailStatusEnum, typing.Sequence[ReceivableMailStatusEnum]]
        ] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableMailPaginationResponse:
        """
        Parameters
        ----------
        receivable_id : str

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ReceivableMailCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        status : typing.Optional[ReceivableMailStatusEnum]

        status_in : typing.Optional[typing.Union[ReceivableMailStatusEnum, typing.Sequence[ReceivableMailStatusEnum]]]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableMailPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_mails(receivable_id='receivable_id', )
        """
        _response = self._raw_client.get_mails(
            receivable_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            status=status,
            status_in=status_in,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    def get_mail_by_id(
        self, receivable_id: str, mail_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableMailResponse:
        """
        Parameters
        ----------
        receivable_id : str

        mail_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableMailResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_mail_by_id(receivable_id='receivable_id', mail_id='mail_id', )
        """
        _response = self._raw_client.get_mail_by_id(receivable_id, mail_id, request_options=request_options)
        return _response.data

    def mark_as_paid_by_id(
        self,
        receivable_id: str,
        *,
        comment: typing.Optional[str] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        comment : typing.Optional[str]
            Optional comment explaining how the payment was made.

        paid_at : typing.Optional[dt.datetime]
            Date and time when the invoice was paid.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.mark_as_paid_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.mark_as_paid_by_id(
            receivable_id, comment=comment, paid_at=paid_at, request_options=request_options
        )
        return _response.data

    def mark_as_partially_paid_by_id(
        self,
        receivable_id: str,
        *,
        amount_paid: int,
        comment: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Deprecated. Use `POST /payment_records` to record an invoice payment.

        Parameters
        ----------
        receivable_id : str

        amount_paid : int
            How much has been paid on the invoice (in minor units).

        comment : typing.Optional[str]
            Optional comment explaining how the payment was made.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.mark_as_partially_paid_by_id(receivable_id='receivable_id', amount_paid=1, )
        """
        _response = self._raw_client.mark_as_partially_paid_by_id(
            receivable_id, amount_paid=amount_paid, comment=comment, request_options=request_options
        )
        return _response.data

    def mark_as_uncollectible_by_id(
        self,
        receivable_id: str,
        *,
        comment: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        comment : typing.Optional[str]
            Optional comment explains why the Invoice goes uncollectible.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.mark_as_uncollectible_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.mark_as_uncollectible_by_id(
            receivable_id, comment=comment, request_options=request_options
        )
        return _response.data

    def get_pdf_link_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableFileUrl:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableFileUrl
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.get_pdf_link_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.get_pdf_link_by_id(receivable_id, request_options=request_options)
        return _response.data

    def preview_by_id(
        self,
        receivable_id: str,
        *,
        body_text: str,
        subject_text: str,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        type: typing.Optional[ReceivablesPreviewTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablePreviewResponse:
        """
        Parameters
        ----------
        receivable_id : str

        body_text : str
            Body text of the content

        subject_text : str
            Subject text of the content

        language : typing.Optional[LanguageCodeEnum]
            Language code for localization purposes

        type : typing.Optional[ReceivablesPreviewTypeEnum]
            The type of the preview document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablePreviewResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.preview_by_id(receivable_id='receivable_id', body_text='body_text', subject_text='subject_text', )
        """
        _response = self._raw_client.preview_by_id(
            receivable_id,
            body_text=body_text,
            subject_text=subject_text,
            language=language,
            type=type,
            request_options=request_options,
        )
        return _response.data

    def send_by_id(
        self,
        receivable_id: str,
        *,
        body_text: str,
        subject_text: str,
        recipients: typing.Optional[Recipients] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableSendResponse:
        """
        Parameters
        ----------
        receivable_id : str

        body_text : str
            Body text of the content

        subject_text : str
            Subject text of the content

        recipients : typing.Optional[Recipients]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableSendResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.send_by_id(receivable_id='receivable_id', body_text='body_text', subject_text='subject_text', )
        """
        _response = self._raw_client.send_by_id(
            receivable_id,
            body_text=body_text,
            subject_text=subject_text,
            recipients=recipients,
            request_options=request_options,
        )
        return _response.data

    def send_test_reminder_by_id(
        self,
        receivable_id: str,
        *,
        reminder_type: ReminderTypeEnum,
        recipients: typing.Optional[Recipients] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablesSendResponse:
        """
        Parameters
        ----------
        receivable_id : str

        reminder_type : ReminderTypeEnum
            The type of the reminder to be sent.

        recipients : typing.Optional[Recipients]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablesSendResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.send_test_reminder_by_id(receivable_id='receivable_id', reminder_type="term_1", )
        """
        _response = self._raw_client.send_test_reminder_by_id(
            receivable_id, reminder_type=reminder_type, recipients=recipients, request_options=request_options
        )
        return _response.data

    def verify_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivablesVerifyResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablesVerifyResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.receivables.verify_by_id(receivable_id='receivable_id', )
        """
        _response = self._raw_client.verify_by_id(receivable_id, request_options=request_options)
        return _response.data


class AsyncReceivablesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawReceivablesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawReceivablesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawReceivablesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        status_in: typing.Optional[
            typing.Union[ReceivablesGetRequestStatusInItem, typing.Sequence[ReceivablesGetRequestStatusInItem]]
        ] = None,
        entity_user_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        sort: typing.Optional[ReceivableCursorFields] = None,
        tag_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        tag_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        product_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        project_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        type: typing.Optional[ReceivableType] = None,
        document_id: typing.Optional[str] = None,
        document_id_contains: typing.Optional[str] = None,
        document_id_icontains: typing.Optional[str] = None,
        issue_date_gt: typing.Optional[dt.datetime] = None,
        issue_date_lt: typing.Optional[dt.datetime] = None,
        issue_date_gte: typing.Optional[dt.datetime] = None,
        issue_date_lte: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        counterpart_id: typing.Optional[str] = None,
        counterpart_name: typing.Optional[str] = None,
        counterpart_name_contains: typing.Optional[str] = None,
        counterpart_name_icontains: typing.Optional[str] = None,
        total_amount: typing.Optional[int] = None,
        total_amount_gt: typing.Optional[int] = None,
        total_amount_lt: typing.Optional[int] = None,
        total_amount_gte: typing.Optional[int] = None,
        total_amount_lte: typing.Optional[int] = None,
        status: typing.Optional[ReceivablesGetRequestStatus] = None,
        entity_user_id: typing.Optional[str] = None,
        based_on: typing.Optional[str] = None,
        due_date_gt: typing.Optional[str] = None,
        due_date_lt: typing.Optional[str] = None,
        due_date_gte: typing.Optional[str] = None,
        due_date_lte: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablePaginationResponse:
        """
        Returns a list of [accounts receivable](https://docs.monite.com/accounts-receivable/index) documents - invoices, quotes, and credit notes - of the specified entity.

        Results can be filtered by amount, counterpart, due date, and other criteria. Multiple filters are combined using logical AND unless specified otherwise. If no documents matching the search criteria are found, the endpoint returns a successful response with an empty `data` array.

        This endpoint supports [pagination](https://docs.monite.com/api/concepts/pagination-sorting-filtering) and sorting. By default, results are sorted by the creation date in ascending order (from oldest to newest).

        #### Examples

        ##### Invoices

        * Get all overdue invoices:
            ```
            GET /receivables?type=invoice&status=overdue
            ```

        * Get all invoices created for the counterpart named "Solarwind" (case-insensitive):

            ```
            GET /receivables?type=invoice?counterpart_name__icontains=Solarwind
            ```

        * Get invoices whose total amount starts from 500 EUR:

            ```
            GET /receivables?type=invoice&total_amount__gte=50000
            ```

        * Get invoices that are due for payment in September 2024:

            ```
            GET /receivables?type=invoice&due_date__gte=2024-09-01T00:00:00Z&due_date__lt=2024-10-01T00:00:00Z
            ```

        * Get invoices created on or after September 1, 2024:

            ```
            GET /receivables?type=invoice&created_at__gte=2024-09-01T00:00:00Z
            ```

        * Find an invoice created from a specific quote:

            ```
            GET /receivables?type=invoice?based_on=QUOTE_ID
            ```

        ##### Quotes

        * Get the latest created quote:

            ```
            GET /receivables?type=quote&sort=created_at&order=desc&limit=1
            ```

        * Get the latest issued quote:

            ```
            GET /receivables?type=quote&sort=issue_date&order=desc&limit=1
            ```

        ##### Credit notes

        * Find all credit notes created for a specific invoice:

            ```
            GET /receivables?type=credit_note?based_on=INVOICE_ID
            ```

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 250) to return in a single page of the response. Default is 100. The response may contain fewer items if it is the last or only page.

            When using pagination with a non-default `limit`, you must provide the `limit` value alongside `pagination_token` in all subsequent pagination requests. Unlike other query parameters, `limit` is not inferred from `pagination_token`.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters except `limit` are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables with the specified IDs. Valid but nonexistent IDs do not raise errors but produce no results.

            To specify multiple IDs, repeat this parameter for each value:
            `id__in=<id1>&id__in=<id2>`

        status_in : typing.Optional[typing.Union[ReceivablesGetRequestStatusInItem, typing.Sequence[ReceivablesGetRequestStatusInItem]]]
            Return only receivables that have the specified statuses. See the applicable [invoice statuses](https://docs.monite.com/accounts-receivable/invoices/index), [quote statuses](https://docs.monite.com/accounts-receivable/quotes/index), and [credit note statuses](https://docs.monite.com/accounts-receivable/credit-notes#credit-note-lifecycle).

            To specify multiple statuses, repeat this parameter for each value:
            `status__in=draft&status__in=issued`

        entity_user_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables created by the entity users with the specified IDs.To specify multiple user IDs, repeat this parameter for each ID:
            `entity_user_id__in=<user1>&entity_user_id__in=<user2>`

            If the request is authenticated using an entity user token, this user must have the `receivable.read.allowed` (rather than `allowed_for_own`) permission to be able to query receivables created by other users.

            IDs of deleted users will still produce results here if those users had associated receivables. Valid but nonexistent user IDs do not raise errors but produce no results.

        sort : typing.Optional[ReceivableCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        tag_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include at least one of the tags with the specified IDs.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagB, tagC


            `tag_ids__in=<tagA>&tag_ids__in=<tagB>` will return receivables 1, 2, 3, and 5.

            Valid but nonexistent tag IDs do not raise errors but produce no results.

        tag_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose [tags](https://docs.monite.com/common/tags) include all of the tags with the specified IDs and optionally other tags that are not specified.

            For example, given receivables with the following tags:
            1. tagA
            2. tagB
            3. tagA, tagB
            4. tagC
            5. tagA, tagB, tagC


            `tag_ids=<tagA>&tag_ids=<tagB>` will return receivables 3 and 5.

        product_ids_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include at least one of the product IDs with the specified IDs.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids__in=<product1>&product_ids__in=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productB, productC


            `product_ids__in=<productA>&product_ids__in=<productB>` will return receivables 1, 2, 3, and 5.Valid but nonexistent product IDs do not raise errors but produce no results.

        product_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose line items include all of the product IDs with the specified IDs and optionally other products that are not specified.

            To specify multiple product IDs, repeat this parameter for each ID:
            `product_ids=<product1>&product_ids=<product2>`

            For example, given receivables with the following product IDs:
            1. productA
            2. productB
            3. productA, productB
            4. productC
            5. productA, productB, productC


            `product_ids=<productA>&product_ids=<productB>` will return receivables 3 and 5.

        project_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only receivables whose `project_id` include at least one of the project_id with the specified IDs. Valid but nonexistent project IDs do not raise errors but produce no results.

        type : typing.Optional[ReceivableType]

        document_id : typing.Optional[str]

        document_id_contains : typing.Optional[str]

        document_id_icontains : typing.Optional[str]

        issue_date_gt : typing.Optional[dt.datetime]

        issue_date_lt : typing.Optional[dt.datetime]

        issue_date_gte : typing.Optional[dt.datetime]

        issue_date_lte : typing.Optional[dt.datetime]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        counterpart_id : typing.Optional[str]

        counterpart_name : typing.Optional[str]

        counterpart_name_contains : typing.Optional[str]

        counterpart_name_icontains : typing.Optional[str]

        total_amount : typing.Optional[int]

        total_amount_gt : typing.Optional[int]

        total_amount_lt : typing.Optional[int]

        total_amount_gte : typing.Optional[int]

        total_amount_lte : typing.Optional[int]

        status : typing.Optional[ReceivablesGetRequestStatus]

        entity_user_id : typing.Optional[str]

        based_on : typing.Optional[str]

        due_date_gt : typing.Optional[str]

        due_date_lt : typing.Optional[str]

        due_date_gte : typing.Optional[str]

        due_date_lte : typing.Optional[str]

        project_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablePaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            id_in=id_in,
            status_in=status_in,
            entity_user_id_in=entity_user_id_in,
            sort=sort,
            tag_ids_in=tag_ids_in,
            tag_ids=tag_ids,
            product_ids_in=product_ids_in,
            product_ids=product_ids,
            project_id_in=project_id_in,
            type=type,
            document_id=document_id,
            document_id_contains=document_id_contains,
            document_id_icontains=document_id_icontains,
            issue_date_gt=issue_date_gt,
            issue_date_lt=issue_date_lt,
            issue_date_gte=issue_date_gte,
            issue_date_lte=issue_date_lte,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            counterpart_id=counterpart_id,
            counterpart_name=counterpart_name,
            counterpart_name_contains=counterpart_name_contains,
            counterpart_name_icontains=counterpart_name_icontains,
            total_amount=total_amount,
            total_amount_gt=total_amount_gt,
            total_amount_lt=total_amount_lt,
            total_amount_gte=total_amount_gte,
            total_amount_lte=total_amount_lte,
            status=status,
            entity_user_id=entity_user_id,
            based_on=based_on,
            due_date_gt=due_date_gt,
            due_date_lt=due_date_lt,
            due_date_gte=due_date_gte,
            due_date_lte=due_date_lte,
            project_id=project_id,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self, *, request: ReceivableFacadeCreatePayload, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        request : ReceivableFacadeCreatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import ReceivableFacadeCreateQuotePayload
        from monite import LineItem
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.create(request=ReceivableFacadeCreateQuotePayload(counterpart_billing_address_id='counterpart_billing_address_id', counterpart_id='counterpart_id', currency="AED", line_items=[LineItem(quantity=1.1, )], ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def get_receivables_required_fields(
        self,
        *,
        counterpart_id: typing.Optional[str] = None,
        counterpart_billing_address_id: typing.Optional[str] = None,
        counterpart_country: typing.Optional[AllowedCountries] = None,
        counterpart_type: typing.Optional[CounterpartType] = None,
        entity_vat_id_id: typing.Optional[str] = None,
        counterpart_vat_id_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableRequiredFields:
        """
        Get field requirements for invoice creation given the entity and counterpart details.

        Parameters
        ----------
        counterpart_id : typing.Optional[str]

        counterpart_billing_address_id : typing.Optional[str]

        counterpart_country : typing.Optional[AllowedCountries]

        counterpart_type : typing.Optional[CounterpartType]

        entity_vat_id_id : typing.Optional[str]

        counterpart_vat_id_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableRequiredFields
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_receivables_required_fields()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_receivables_required_fields(
            counterpart_id=counterpart_id,
            counterpart_billing_address_id=counterpart_billing_address_id,
            counterpart_country=counterpart_country,
            counterpart_type=counterpart_type,
            entity_vat_id_id=entity_vat_id_id,
            counterpart_vat_id_id=counterpart_vat_id_id,
            request_options=request_options,
        )
        return _response.data

    async def get_variables(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableTemplatesVariablesObjectList:
        """
        Get a list of placeholders that can be used in email templates for customization.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableTemplatesVariablesObjectList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_variables()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_variables(request_options=request_options)
        return _response.data

    async def get_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(receivable_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.delete_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(receivable_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        receivable_id: str,
        *,
        request: ReceivableUpdatePayload,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request : ReceivableUpdatePayload

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import UpdateQuotePayload
        from monite import UpdateQuote
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.update_by_id(receivable_id='receivable_id', request=UpdateQuotePayload(quote=UpdateQuote(), ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(receivable_id, request=request, request_options=request_options)
        return _response.data

    async def accept_by_id(
        self,
        receivable_id: str,
        *,
        signature: typing.Optional[Signature] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResult:
        """
        Parameters
        ----------
        receivable_id : str

        signature : typing.Optional[Signature]
            A digital signature, if required for quote acceptance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResult
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.accept_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.accept_by_id(
            receivable_id, signature=signature, request_options=request_options
        )
        return _response.data

    async def cancel_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.cancel_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_by_id(receivable_id, request_options=request_options)
        return _response.data

    async def clone_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.clone_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.clone_by_id(receivable_id, request_options=request_options)
        return _response.data

    async def decline_by_id(
        self,
        receivable_id: str,
        *,
        comment: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SuccessResult:
        """
        Parameters
        ----------
        receivable_id : str

        comment : typing.Optional[str]
            Field with a comment on why the client declined this Quote

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SuccessResult
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.decline_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.decline_by_id(
            receivable_id, comment=comment, request_options=request_options
        )
        return _response.data

    async def get_history(
        self,
        receivable_id: str,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ReceivableHistoryCursorFields] = None,
        event_type_in: typing.Optional[
            typing.Union[ReceivableHistoryEventTypeEnum, typing.Sequence[ReceivableHistoryEventTypeEnum]]
        ] = None,
        entity_user_id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        timestamp_gt: typing.Optional[dt.datetime] = None,
        timestamp_lt: typing.Optional[dt.datetime] = None,
        timestamp_gte: typing.Optional[dt.datetime] = None,
        timestamp_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableHistoryPaginationResponse:
        """
        Returns the history of the specified accounts receivable document. The history contains all revisions of the document, status updates, and other events that occurred during the document's lifecycle. For more information, see [Document history](https://docs.monite.com/accounts-receivable/document-history).

        You can filter the history by the date range and event type. Events are sorted from oldest to newest by default.

        Parameters
        ----------
        receivable_id : str
            ID of the accounts receivable document whose history you want to get.

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ReceivableHistoryCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        event_type_in : typing.Optional[typing.Union[ReceivableHistoryEventTypeEnum, typing.Sequence[ReceivableHistoryEventTypeEnum]]]
            Return only the specified [event types](https://docs.monite.com/accounts-receivable/document-history#event-types). To include multiple types, repeat this parameter for each value:
            `event_type__in=receivable_updated&event_type__in=status_changed`

        entity_user_id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Return only events caused by the entity users with the specified IDs. To specify multiple user IDs, repeat this parameter for each ID:
            `entity_user_id__in=<user1>&entity_user_id__in=<user2>`

        timestamp_gt : typing.Optional[dt.datetime]
            Return only events that occurred after the specified date and time. The value must be in the ISO 8601 format `YYYY-MM-DDThh:mm[:ss[.ffffff]][Z|±hh:mm]`.

        timestamp_lt : typing.Optional[dt.datetime]
            Return only events that occurred before the specified date and time.

        timestamp_gte : typing.Optional[dt.datetime]
            Return only events that occurred on or after the specified date and time.

        timestamp_lte : typing.Optional[dt.datetime]
            Return only events that occurred before or on the specified date and time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableHistoryPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_history(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_history(
            receivable_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            event_type_in=event_type_in,
            entity_user_id_in=entity_user_id_in,
            timestamp_gt=timestamp_gt,
            timestamp_lt=timestamp_lt,
            timestamp_gte=timestamp_gte,
            timestamp_lte=timestamp_lte,
            request_options=request_options,
        )
        return _response.data

    async def get_history_by_id(
        self, receivable_history_id: str, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableHistoryResponse:
        """
        Returns a single record from the change history of the specified accounts receivable document.

        Parameters
        ----------
        receivable_history_id : str
            ID of the history record to return. You can get these IDs from `GET /receivables/{receivable_id}/history`.

        receivable_id : str
            ID of the accounts receivable document whose history you want to get.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableHistoryResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_history_by_id(receivable_history_id='receivable_history_id', receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_history_by_id(
            receivable_history_id, receivable_id, request_options=request_options
        )
        return _response.data

    async def issue_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.issue_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.issue_by_id(receivable_id, request_options=request_options)
        return _response.data

    async def update_line_items_by_id(
        self,
        receivable_id: str,
        *,
        data: typing.Sequence[LineItem],
        request_options: typing.Optional[RequestOptions] = None,
    ) -> LineItemsResponse:
        """
        Replace all line items of an existing invoice or quote with a new list of line items.

        Parameters
        ----------
        receivable_id : str

        data : typing.Sequence[LineItem]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        LineItemsResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import LineItem
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.update_line_items_by_id(receivable_id='receivable_id', data=[LineItem(quantity=1.1, )], )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_line_items_by_id(
            receivable_id, data=data, request_options=request_options
        )
        return _response.data

    async def get_mails(
        self,
        receivable_id: str,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[ReceivableMailCursorFields] = None,
        status: typing.Optional[ReceivableMailStatusEnum] = None,
        status_in: typing.Optional[
            typing.Union[ReceivableMailStatusEnum, typing.Sequence[ReceivableMailStatusEnum]]
        ] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableMailPaginationResponse:
        """
        Parameters
        ----------
        receivable_id : str

        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[ReceivableMailCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        status : typing.Optional[ReceivableMailStatusEnum]

        status_in : typing.Optional[typing.Union[ReceivableMailStatusEnum, typing.Sequence[ReceivableMailStatusEnum]]]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableMailPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_mails(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_mails(
            receivable_id,
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            status=status,
            status_in=status_in,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def get_mail_by_id(
        self, receivable_id: str, mail_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableMailResponse:
        """
        Parameters
        ----------
        receivable_id : str

        mail_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableMailResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_mail_by_id(receivable_id='receivable_id', mail_id='mail_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_mail_by_id(receivable_id, mail_id, request_options=request_options)
        return _response.data

    async def mark_as_paid_by_id(
        self,
        receivable_id: str,
        *,
        comment: typing.Optional[str] = OMIT,
        paid_at: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        comment : typing.Optional[str]
            Optional comment explaining how the payment was made.

        paid_at : typing.Optional[dt.datetime]
            Date and time when the invoice was paid.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.mark_as_paid_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.mark_as_paid_by_id(
            receivable_id, comment=comment, paid_at=paid_at, request_options=request_options
        )
        return _response.data

    async def mark_as_partially_paid_by_id(
        self,
        receivable_id: str,
        *,
        amount_paid: int,
        comment: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Deprecated. Use `POST /payment_records` to record an invoice payment.

        Parameters
        ----------
        receivable_id : str

        amount_paid : int
            How much has been paid on the invoice (in minor units).

        comment : typing.Optional[str]
            Optional comment explaining how the payment was made.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.mark_as_partially_paid_by_id(receivable_id='receivable_id', amount_paid=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.mark_as_partially_paid_by_id(
            receivable_id, amount_paid=amount_paid, comment=comment, request_options=request_options
        )
        return _response.data

    async def mark_as_uncollectible_by_id(
        self,
        receivable_id: str,
        *,
        comment: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableResponse:
        """
        Parameters
        ----------
        receivable_id : str

        comment : typing.Optional[str]
            Optional comment explains why the Invoice goes uncollectible.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.mark_as_uncollectible_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.mark_as_uncollectible_by_id(
            receivable_id, comment=comment, request_options=request_options
        )
        return _response.data

    async def get_pdf_link_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivableFileUrl:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableFileUrl
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.get_pdf_link_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_pdf_link_by_id(receivable_id, request_options=request_options)
        return _response.data

    async def preview_by_id(
        self,
        receivable_id: str,
        *,
        body_text: str,
        subject_text: str,
        language: typing.Optional[LanguageCodeEnum] = OMIT,
        type: typing.Optional[ReceivablesPreviewTypeEnum] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablePreviewResponse:
        """
        Parameters
        ----------
        receivable_id : str

        body_text : str
            Body text of the content

        subject_text : str
            Subject text of the content

        language : typing.Optional[LanguageCodeEnum]
            Language code for localization purposes

        type : typing.Optional[ReceivablesPreviewTypeEnum]
            The type of the preview document.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablePreviewResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.preview_by_id(receivable_id='receivable_id', body_text='body_text', subject_text='subject_text', )
        asyncio.run(main())
        """
        _response = await self._raw_client.preview_by_id(
            receivable_id,
            body_text=body_text,
            subject_text=subject_text,
            language=language,
            type=type,
            request_options=request_options,
        )
        return _response.data

    async def send_by_id(
        self,
        receivable_id: str,
        *,
        body_text: str,
        subject_text: str,
        recipients: typing.Optional[Recipients] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivableSendResponse:
        """
        Parameters
        ----------
        receivable_id : str

        body_text : str
            Body text of the content

        subject_text : str
            Subject text of the content

        recipients : typing.Optional[Recipients]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivableSendResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.send_by_id(receivable_id='receivable_id', body_text='body_text', subject_text='subject_text', )
        asyncio.run(main())
        """
        _response = await self._raw_client.send_by_id(
            receivable_id,
            body_text=body_text,
            subject_text=subject_text,
            recipients=recipients,
            request_options=request_options,
        )
        return _response.data

    async def send_test_reminder_by_id(
        self,
        receivable_id: str,
        *,
        reminder_type: ReminderTypeEnum,
        recipients: typing.Optional[Recipients] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ReceivablesSendResponse:
        """
        Parameters
        ----------
        receivable_id : str

        reminder_type : ReminderTypeEnum
            The type of the reminder to be sent.

        recipients : typing.Optional[Recipients]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablesSendResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.send_test_reminder_by_id(receivable_id='receivable_id', reminder_type="term_1", )
        asyncio.run(main())
        """
        _response = await self._raw_client.send_test_reminder_by_id(
            receivable_id, reminder_type=reminder_type, recipients=recipients, request_options=request_options
        )
        return _response.data

    async def verify_by_id(
        self, receivable_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ReceivablesVerifyResponse:
        """
        Parameters
        ----------
        receivable_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ReceivablesVerifyResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.receivables.verify_by_id(receivable_id='receivable_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.verify_by_id(receivable_id, request_options=request_options)
        return _response.data
