# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.automation_level import AutomationLevel
from ..types.day_of_month import DayOfMonth
from ..types.get_all_recurrences import GetAllRecurrences
from ..types.recipients import Recipients
from ..types.recurrence import Recurrence
from .raw_client import AsyncRawRecurrencesClient, RawRecurrencesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RecurrencesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRecurrencesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRecurrencesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRecurrencesClient
        """
        return self._raw_client

    def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetAllRecurrences:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAllRecurrences
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.recurrences.get()
        """
        _response = self._raw_client.get(request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        day_of_month: DayOfMonth,
        end_month: int,
        end_year: int,
        invoice_id: str,
        start_month: int,
        start_year: int,
        automation_level: typing.Optional[AutomationLevel] = OMIT,
        body_text: typing.Optional[str] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        subject_text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Recurrence:
        """
        Parameters
        ----------
        day_of_month : DayOfMonth

        end_month : int

        end_year : int

        invoice_id : str

        start_month : int

        start_year : int

        automation_level : typing.Optional[AutomationLevel]
            Controls how invoices are processed when generated:
            - "draft": Creates invoices in draft status, requiring manual review, issuing, and sending
            - "issue": Automatically issues invoices but requires manual sending
            - "issue_and_send": Fully automates the process (creates, issues, and sends invoices)

            Default: "issue" (or "issue_and_send" if subject_text and body_text are provided)

            Note: When using "issue_and_send", both subject_text and body_text must be provided.

        body_text : typing.Optional[str]

        recipients : typing.Optional[Recipients]

        subject_text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Recurrence
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.recurrences.create(day_of_month="first_day", end_month=1, end_year=1, invoice_id='invoice_id', start_month=1, start_year=1, )
        """
        _response = self._raw_client.create(
            day_of_month=day_of_month,
            end_month=end_month,
            end_year=end_year,
            invoice_id=invoice_id,
            start_month=start_month,
            start_year=start_year,
            automation_level=automation_level,
            body_text=body_text,
            recipients=recipients,
            subject_text=subject_text,
            request_options=request_options,
        )
        return _response.data

    def get_by_id(self, recurrence_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Recurrence:
        """
        Parameters
        ----------
        recurrence_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Recurrence
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.recurrences.get_by_id(recurrence_id='recurrence_id', )
        """
        _response = self._raw_client.get_by_id(recurrence_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        recurrence_id: str,
        *,
        automation_level: typing.Optional[AutomationLevel] = OMIT,
        body_text: typing.Optional[str] = OMIT,
        day_of_month: typing.Optional[DayOfMonth] = OMIT,
        end_month: typing.Optional[int] = OMIT,
        end_year: typing.Optional[int] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        subject_text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Recurrence:
        """
        Parameters
        ----------
        recurrence_id : str

        automation_level : typing.Optional[AutomationLevel]
            Controls how invoices are processed when generated:
            - "draft": Creates invoices in draft status, requiring manual review, issuing, and sending
            - "issue": Automatically issues invoices but requires manual sending
            - "issue_and_send": Fully automates the process (creates, issues, and sends invoices)

            Default: "issue" (or "issue_and_send" if subject_text and body_text are provided)

            Note: When using "issue_and_send", both subject_text and body_text must be provided.

        body_text : typing.Optional[str]

        day_of_month : typing.Optional[DayOfMonth]

        end_month : typing.Optional[int]

        end_year : typing.Optional[int]

        recipients : typing.Optional[Recipients]

        subject_text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Recurrence
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.recurrences.update_by_id(recurrence_id='recurrence_id', )
        """
        _response = self._raw_client.update_by_id(
            recurrence_id,
            automation_level=automation_level,
            body_text=body_text,
            day_of_month=day_of_month,
            end_month=end_month,
            end_year=end_year,
            recipients=recipients,
            subject_text=subject_text,
            request_options=request_options,
        )
        return _response.data

    def cancel_by_id(self, recurrence_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Parameters
        ----------
        recurrence_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.recurrences.cancel_by_id(recurrence_id='recurrence_id', )
        """
        _response = self._raw_client.cancel_by_id(recurrence_id, request_options=request_options)
        return _response.data


class AsyncRecurrencesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRecurrencesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRecurrencesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRecurrencesClient
        """
        return self._raw_client

    async def get(self, *, request_options: typing.Optional[RequestOptions] = None) -> GetAllRecurrences:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetAllRecurrences
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.recurrences.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        day_of_month: DayOfMonth,
        end_month: int,
        end_year: int,
        invoice_id: str,
        start_month: int,
        start_year: int,
        automation_level: typing.Optional[AutomationLevel] = OMIT,
        body_text: typing.Optional[str] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        subject_text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Recurrence:
        """
        Parameters
        ----------
        day_of_month : DayOfMonth

        end_month : int

        end_year : int

        invoice_id : str

        start_month : int

        start_year : int

        automation_level : typing.Optional[AutomationLevel]
            Controls how invoices are processed when generated:
            - "draft": Creates invoices in draft status, requiring manual review, issuing, and sending
            - "issue": Automatically issues invoices but requires manual sending
            - "issue_and_send": Fully automates the process (creates, issues, and sends invoices)

            Default: "issue" (or "issue_and_send" if subject_text and body_text are provided)

            Note: When using "issue_and_send", both subject_text and body_text must be provided.

        body_text : typing.Optional[str]

        recipients : typing.Optional[Recipients]

        subject_text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Recurrence
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.recurrences.create(day_of_month="first_day", end_month=1, end_year=1, invoice_id='invoice_id', start_month=1, start_year=1, )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            day_of_month=day_of_month,
            end_month=end_month,
            end_year=end_year,
            invoice_id=invoice_id,
            start_month=start_month,
            start_year=start_year,
            automation_level=automation_level,
            body_text=body_text,
            recipients=recipients,
            subject_text=subject_text,
            request_options=request_options,
        )
        return _response.data

    async def get_by_id(
        self, recurrence_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Recurrence:
        """
        Parameters
        ----------
        recurrence_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Recurrence
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.recurrences.get_by_id(recurrence_id='recurrence_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(recurrence_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        recurrence_id: str,
        *,
        automation_level: typing.Optional[AutomationLevel] = OMIT,
        body_text: typing.Optional[str] = OMIT,
        day_of_month: typing.Optional[DayOfMonth] = OMIT,
        end_month: typing.Optional[int] = OMIT,
        end_year: typing.Optional[int] = OMIT,
        recipients: typing.Optional[Recipients] = OMIT,
        subject_text: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Recurrence:
        """
        Parameters
        ----------
        recurrence_id : str

        automation_level : typing.Optional[AutomationLevel]
            Controls how invoices are processed when generated:
            - "draft": Creates invoices in draft status, requiring manual review, issuing, and sending
            - "issue": Automatically issues invoices but requires manual sending
            - "issue_and_send": Fully automates the process (creates, issues, and sends invoices)

            Default: "issue" (or "issue_and_send" if subject_text and body_text are provided)

            Note: When using "issue_and_send", both subject_text and body_text must be provided.

        body_text : typing.Optional[str]

        day_of_month : typing.Optional[DayOfMonth]

        end_month : typing.Optional[int]

        end_year : typing.Optional[int]

        recipients : typing.Optional[Recipients]

        subject_text : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Recurrence
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.recurrences.update_by_id(recurrence_id='recurrence_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            recurrence_id,
            automation_level=automation_level,
            body_text=body_text,
            day_of_month=day_of_month,
            end_month=end_month,
            end_year=end_year,
            recipients=recipients,
            subject_text=subject_text,
            request_options=request_options,
        )
        return _response.data

    async def cancel_by_id(
        self, recurrence_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        recurrence_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.recurrences.cancel_by_id(recurrence_id='recurrence_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_by_id(recurrence_id, request_options=request_options)
        return _response.data
