# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.biz_objects_schema_input import BizObjectsSchemaInput
from ..types.order_enum import OrderEnum
from ..types.role_cursor_fields import RoleCursorFields
from ..types.role_pagination_response import RolePaginationResponse
from ..types.role_response import RoleResponse
from .raw_client import AsyncRawRolesClient, RawRolesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RolesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRolesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRolesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRolesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[RoleCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        created_at: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RolePaginationResponse:
        """
        Find all roles that match the search criteria.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[RoleCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        created_at : typing.Optional[dt.datetime]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RolePaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.roles.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            name=name,
            created_at=created_at,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    def create(
        self, *, name: str, permissions: BizObjectsSchemaInput, request_options: typing.Optional[RequestOptions] = None
    ) -> RoleResponse:
        """
        Create a new role from the specified values.

        Parameters
        ----------
        name : str
            Role name

        permissions : BizObjectsSchemaInput
            Access permissions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        from monite import BizObjectsSchemaInput
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.roles.create(name='name', permissions=BizObjectsSchemaInput(), )
        """
        _response = self._raw_client.create(name=name, permissions=permissions, request_options=request_options)
        return _response.data

    def get_by_id(self, role_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> RoleResponse:
        """
        Parameters
        ----------
        role_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.roles.get_by_id(role_id='role_id', )
        """
        _response = self._raw_client.get_by_id(role_id, request_options=request_options)
        return _response.data

    def delete_roles_id(self, role_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a role with the specified ID. The role being deleted must not be in use by any entity users, otherwise a 409 error is returned. To check if there are entity users that have this role, call `GET /entity_users?role_id=ROLE_ID`.

        Parameters
        ----------
        role_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.roles.delete_roles_id(role_id='role_id', )
        """
        _response = self._raw_client.delete_roles_id(role_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        role_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        permissions: typing.Optional[BizObjectsSchemaInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RoleResponse:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        role_id : str

        name : typing.Optional[str]
            Role name

        permissions : typing.Optional[BizObjectsSchemaInput]
            Access permissions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.roles.update_by_id(role_id='role_id', )
        """
        _response = self._raw_client.update_by_id(
            role_id, name=name, permissions=permissions, request_options=request_options
        )
        return _response.data


class AsyncRolesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRolesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRolesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRolesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[RoleCursorFields] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        created_at: typing.Optional[dt.datetime] = None,
        created_at_gt: typing.Optional[dt.datetime] = None,
        created_at_lt: typing.Optional[dt.datetime] = None,
        created_at_gte: typing.Optional[dt.datetime] = None,
        created_at_lte: typing.Optional[dt.datetime] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RolePaginationResponse:
        """
        Find all roles that match the search criteria.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[RoleCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        name : typing.Optional[str]

        created_at : typing.Optional[dt.datetime]

        created_at_gt : typing.Optional[dt.datetime]

        created_at_lt : typing.Optional[dt.datetime]

        created_at_gte : typing.Optional[dt.datetime]

        created_at_lte : typing.Optional[dt.datetime]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RolePaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.roles.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            id_in=id_in,
            name=name,
            created_at=created_at,
            created_at_gt=created_at_gt,
            created_at_lt=created_at_lt,
            created_at_gte=created_at_gte,
            created_at_lte=created_at_lte,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self, *, name: str, permissions: BizObjectsSchemaInput, request_options: typing.Optional[RequestOptions] = None
    ) -> RoleResponse:
        """
        Create a new role from the specified values.

        Parameters
        ----------
        name : str
            Role name

        permissions : BizObjectsSchemaInput
            Access permissions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        from monite import BizObjectsSchemaInput
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.roles.create(name='name', permissions=BizObjectsSchemaInput(), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, permissions=permissions, request_options=request_options)
        return _response.data

    async def get_by_id(self, role_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> RoleResponse:
        """
        Parameters
        ----------
        role_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.roles.get_by_id(role_id='role_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(role_id, request_options=request_options)
        return _response.data

    async def delete_roles_id(self, role_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a role with the specified ID. The role being deleted must not be in use by any entity users, otherwise a 409 error is returned. To check if there are entity users that have this role, call `GET /entity_users?role_id=ROLE_ID`.

        Parameters
        ----------
        role_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.roles.delete_roles_id(role_id='role_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_roles_id(role_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        role_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        permissions: typing.Optional[BizObjectsSchemaInput] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RoleResponse:
        """
        Change the specified fields with the provided values.

        Parameters
        ----------
        role_id : str

        name : typing.Optional[str]
            Role name

        permissions : typing.Optional[BizObjectsSchemaInput]
            Access permissions

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RoleResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.roles.update_by_id(role_id='role_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            role_id, name=name, permissions=permissions, request_options=request_options
        )
        return _response.data
