# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.order_enum import OrderEnum
from ..types.tag_category import TagCategory
from ..types.tag_cursor_fields import TagCursorFields
from ..types.tag_read_schema import TagReadSchema
from ..types.tags_pagination_response import TagsPaginationResponse
from .raw_client import AsyncRawTagsClient, RawTagsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TagsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTagsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTagsClient
        """
        return self._raw_client

    def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[TagCursorFields] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        name_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagsPaginationResponse:
        """
        Get a list of all tags. Tags can be assigned to resources to assist with searching and filtering.
            Tags can also be used as trigger conditions in payable approval policies.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[TagCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_by_entity_user_id : typing.Optional[str]

        name_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagsPaginationResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.tags.get()
        """
        _response = self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_by_entity_user_id=created_by_entity_user_id,
            name_in=name_in,
            id_in=id_in,
            request_options=request_options,
        )
        return _response.data

    def create(
        self,
        *,
        name: str,
        category: typing.Optional[TagCategory] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagReadSchema:
        """
        Create a new tag. The tag name must be unique.
            Tag names are case-sensitive, that is `Marketing` and `marketing` are two different tags.


        The response returns an auto-generated ID assigned to this tag.
        To assign this tag to a resource, send the tag ID in the `tag_ids` list when creating or updating a resource.

        Parameters
        ----------
        name : str
            The tag name. Must be unique.

        category : typing.Optional[TagCategory]
            The tag category.

        description : typing.Optional[str]
            The tag description.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagReadSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.tags.create(name='Marketing', )
        """
        _response = self._raw_client.create(
            name=name, category=category, description=description, request_options=request_options
        )
        return _response.data

    def get_by_id(self, tag_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> TagReadSchema:
        """
        Get information about a tag with the given ID.

        Parameters
        ----------
        tag_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagReadSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.tags.get_by_id(tag_id='tag_id', )
        """
        _response = self._raw_client.get_by_id(tag_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, tag_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a tag with the given ID. This tag will be automatically deleted from all resources where it was used.

        Parameters
        ----------
        tag_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.tags.delete_by_id(tag_id='tag_id', )
        """
        _response = self._raw_client.delete_by_id(tag_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        tag_id: str,
        *,
        category: typing.Optional[TagCategory] = OMIT,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagReadSchema:
        """
        Change the tag name. The new name must be unique among existing tags.
            Tag names are case-sensitive, that is `Marketing` and `marketing` are two different tags.

        Parameters
        ----------
        tag_id : str

        category : typing.Optional[TagCategory]
            The tag category.

        description : typing.Optional[str]
            The tag description.

        name : typing.Optional[str]
            The tag name. Must be unique.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagReadSchema
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.tags.update_by_id(tag_id='tag_id', )
        """
        _response = self._raw_client.update_by_id(
            tag_id, category=category, description=description, name=name, request_options=request_options
        )
        return _response.data


class AsyncTagsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTagsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTagsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTagsClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        order: typing.Optional[OrderEnum] = None,
        limit: typing.Optional[int] = None,
        pagination_token: typing.Optional[str] = None,
        sort: typing.Optional[TagCursorFields] = None,
        created_by_entity_user_id: typing.Optional[str] = None,
        name_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        id_in: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagsPaginationResponse:
        """
        Get a list of all tags. Tags can be assigned to resources to assist with searching and filtering.
            Tags can also be used as trigger conditions in payable approval policies.

        Parameters
        ----------
        order : typing.Optional[OrderEnum]
            Sort order (ascending by default). Typically used together with the `sort` parameter.

        limit : typing.Optional[int]
            The number of items (0 .. 100) to return in a single page of the response. The response may contain fewer items if it is the last or only page.

        pagination_token : typing.Optional[str]
            A pagination token obtained from a previous call to this endpoint. Use it to get the next or previous page of results for your initial query. If `pagination_token` is specified, all other query parameters are ignored and inferred from the initial query.

            If not specified, the first page of results will be returned.

        sort : typing.Optional[TagCursorFields]
            The field to sort the results by. Typically used together with the `order` parameter.

        created_by_entity_user_id : typing.Optional[str]

        name_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        id_in : typing.Optional[typing.Union[str, typing.Sequence[str]]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagsPaginationResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.tags.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            order=order,
            limit=limit,
            pagination_token=pagination_token,
            sort=sort,
            created_by_entity_user_id=created_by_entity_user_id,
            name_in=name_in,
            id_in=id_in,
            request_options=request_options,
        )
        return _response.data

    async def create(
        self,
        *,
        name: str,
        category: typing.Optional[TagCategory] = OMIT,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagReadSchema:
        """
        Create a new tag. The tag name must be unique.
            Tag names are case-sensitive, that is `Marketing` and `marketing` are two different tags.


        The response returns an auto-generated ID assigned to this tag.
        To assign this tag to a resource, send the tag ID in the `tag_ids` list when creating or updating a resource.

        Parameters
        ----------
        name : str
            The tag name. Must be unique.

        category : typing.Optional[TagCategory]
            The tag category.

        description : typing.Optional[str]
            The tag description.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagReadSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.tags.create(name='Marketing', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name, category=category, description=description, request_options=request_options
        )
        return _response.data

    async def get_by_id(self, tag_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> TagReadSchema:
        """
        Get information about a tag with the given ID.

        Parameters
        ----------
        tag_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagReadSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.tags.get_by_id(tag_id='tag_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(tag_id, request_options=request_options)
        return _response.data

    async def delete_by_id(self, tag_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete a tag with the given ID. This tag will be automatically deleted from all resources where it was used.

        Parameters
        ----------
        tag_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.tags.delete_by_id(tag_id='tag_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(tag_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        tag_id: str,
        *,
        category: typing.Optional[TagCategory] = OMIT,
        description: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TagReadSchema:
        """
        Change the tag name. The new name must be unique among existing tags.
            Tag names are case-sensitive, that is `Marketing` and `marketing` are two different tags.

        Parameters
        ----------
        tag_id : str

        category : typing.Optional[TagCategory]
            The tag category.

        description : typing.Optional[str]
            The tag description.

        name : typing.Optional[str]
            The tag name. Must be unique.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TagReadSchema
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.tags.update_by_id(tag_id='tag_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            tag_id, category=category, description=description, name=name, request_options=request_options
        )
        return _response.data
