# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.text_template_document_type_enum import TextTemplateDocumentTypeEnum
from ..types.text_template_response import TextTemplateResponse
from ..types.text_template_response_list import TextTemplateResponseList
from ..types.text_template_type import TextTemplateType
from .raw_client import AsyncRawTextTemplatesClient, RawTextTemplatesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TextTemplatesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTextTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTextTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTextTemplatesClient
        """
        return self._raw_client

    def get(
        self,
        *,
        type: typing.Optional[TextTemplateType] = None,
        document_type: typing.Optional[TextTemplateDocumentTypeEnum] = None,
        is_default: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextTemplateResponseList:
        """
        Get text templates

        Parameters
        ----------
        type : typing.Optional[TextTemplateType]

        document_type : typing.Optional[TextTemplateDocumentTypeEnum]

        is_default : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponseList
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.text_templates.get()
        """
        _response = self._raw_client.get(
            type=type, document_type=document_type, is_default=is_default, request_options=request_options
        )
        return _response.data

    def create(
        self,
        *,
        document_type: TextTemplateDocumentTypeEnum,
        name: str,
        template: str,
        type: TextTemplateType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextTemplateResponse:
        """
        Create a text template

        Parameters
        ----------
        document_type : TextTemplateDocumentTypeEnum

        name : str

        template : str

        type : TextTemplateType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.text_templates.create(document_type="quote", name='name', template='template', type="email_header", )
        """
        _response = self._raw_client.create(
            document_type=document_type, name=name, template=template, type=type, request_options=request_options
        )
        return _response.data

    def get_by_id(
        self, text_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TextTemplateResponse:
        """
        Get all custom contents

        Parameters
        ----------
        text_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.text_templates.get_by_id(text_template_id='text_template_id', )
        """
        _response = self._raw_client.get_by_id(text_template_id, request_options=request_options)
        return _response.data

    def delete_by_id(self, text_template_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Delete custom content by ID

        Parameters
        ----------
        text_template_id : str
            UUID text_template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.text_templates.delete_by_id(text_template_id='text_template_id', )
        """
        _response = self._raw_client.delete_by_id(text_template_id, request_options=request_options)
        return _response.data

    def update_by_id(
        self,
        text_template_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        template: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextTemplateResponse:
        """
        Update custom content by ID

        Parameters
        ----------
        text_template_id : str
            UUID text_template ID

        name : typing.Optional[str]

        template : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.text_templates.update_by_id(text_template_id='text_template_id', )
        """
        _response = self._raw_client.update_by_id(
            text_template_id, name=name, template=template, request_options=request_options
        )
        return _response.data

    def make_default_by_id(
        self, text_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TextTemplateResponse:
        """
        Make text template default

        Parameters
        ----------
        text_template_id : str
            UUID text_template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import Monite
        client = Monite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        client.text_templates.make_default_by_id(text_template_id='text_template_id', )
        """
        _response = self._raw_client.make_default_by_id(text_template_id, request_options=request_options)
        return _response.data


class AsyncTextTemplatesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTextTemplatesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTextTemplatesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTextTemplatesClient
        """
        return self._raw_client

    async def get(
        self,
        *,
        type: typing.Optional[TextTemplateType] = None,
        document_type: typing.Optional[TextTemplateDocumentTypeEnum] = None,
        is_default: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextTemplateResponseList:
        """
        Get text templates

        Parameters
        ----------
        type : typing.Optional[TextTemplateType]

        document_type : typing.Optional[TextTemplateDocumentTypeEnum]

        is_default : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponseList
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.text_templates.get()
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            type=type, document_type=document_type, is_default=is_default, request_options=request_options
        )
        return _response.data

    async def create(
        self,
        *,
        document_type: TextTemplateDocumentTypeEnum,
        name: str,
        template: str,
        type: TextTemplateType,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextTemplateResponse:
        """
        Create a text template

        Parameters
        ----------
        document_type : TextTemplateDocumentTypeEnum

        name : str

        template : str

        type : TextTemplateType

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.text_templates.create(document_type="quote", name='name', template='template', type="email_header", )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            document_type=document_type, name=name, template=template, type=type, request_options=request_options
        )
        return _response.data

    async def get_by_id(
        self, text_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TextTemplateResponse:
        """
        Get all custom contents

        Parameters
        ----------
        text_template_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.text_templates.get_by_id(text_template_id='text_template_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_id(text_template_id, request_options=request_options)
        return _response.data

    async def delete_by_id(
        self, text_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Delete custom content by ID

        Parameters
        ----------
        text_template_id : str
            UUID text_template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.text_templates.delete_by_id(text_template_id='text_template_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete_by_id(text_template_id, request_options=request_options)
        return _response.data

    async def update_by_id(
        self,
        text_template_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        template: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TextTemplateResponse:
        """
        Update custom content by ID

        Parameters
        ----------
        text_template_id : str
            UUID text_template ID

        name : typing.Optional[str]

        template : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.text_templates.update_by_id(text_template_id='text_template_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.update_by_id(
            text_template_id, name=name, template=template, request_options=request_options
        )
        return _response.data

    async def make_default_by_id(
        self, text_template_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> TextTemplateResponse:
        """
        Make text template default

        Parameters
        ----------
        text_template_id : str
            UUID text_template ID

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TextTemplateResponse
            Successful Response

        Examples
        --------
        from monite import AsyncMonite
        import asyncio
        client = AsyncMonite(monite_version="YOUR_MONITE_VERSION", monite_entity_id="YOUR_MONITE_ENTITY_ID", token="YOUR_TOKEN", )
        async def main() -> None:
            await client.text_templates.make_default_by_id(text_template_id='text_template_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.make_default_by_id(text_template_id, request_options=request_options)
        return _response.data
