# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .accounting_ref_object import AccountingRefObject


class AccountingLineItem(UniversalBaseModel):
    """
    Contains the details of an invoice line item retrieved from an accounting system.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name or description of the product or service being invoiced.
    """

    discount_amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    Discount amount for this line item (if any).
    """

    discount_percentage: typing.Optional[float] = pydantic.Field(default=None)
    """
    Discount percentage for this line item (if any).
    """

    ledger_account_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the ledger account associated with this line item. You can use `GET /ledger_accounts/{ledger_account_id}` to get further details about this ledger account.
    """

    quantity: typing.Optional[float] = pydantic.Field(default=None)
    """
    The quantity of the product or service.
    """

    tax_rate_ref: typing.Optional[AccountingRefObject] = pydantic.Field(default=None)
    """
    An internal reference to the tax rate in the accounting system that the line item is linked to.
    """

    unit_amount: typing.Optional[float] = pydantic.Field(default=None)
    """
    The cost per unit of the product or service.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
