# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .accounting_customer_ref_object import AccountingCustomerRefObject
from .accounting_line_item import AccountingLineItem
from .accounting_receivable_due_date import AccountingReceivableDueDate


class AccountingReceivable(UniversalBaseModel):
    """
    Invoice details retrieved from an accounting system.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    An internal identifier of the invoice in the accounting system.
    """

    currency: typing.Optional[str] = pydantic.Field(default=None)
    """
    ISO-4217 currency code of the invoice.
    """

    currency_rate: typing.Optional[float] = pydantic.Field(default=None)
    """
    Rate to convert the total amount of the transaction into the entity's base currency at the time of the transaction.
    """

    customer_ref: typing.Optional[AccountingCustomerRefObject] = pydantic.Field(default=None)
    """
    Information about the customer that the invoice was sent to.
    """

    due_date: typing.Optional[AccountingReceivableDueDate] = pydantic.Field(default=None)
    """
    Invoice due date.
    """

    invoice_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Invoice document number.
    """

    lines: typing.Optional[typing.List[AccountingLineItem]] = None
    memo: typing.Optional[str] = pydantic.Field(default=None)
    """
    Any additional information or business notes about the invoice.
    """

    pass_through: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    An object containing additional invoice data returned by the accounting system. This sometimes includes custom invoice fields.
    """

    posted_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date when the invoice was added to the accounting service. This may differ from the invoice creation date.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
