# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .default_accounting_tax_i_ds import DefaultAccountingTaxIDs
from .default_ledger_account_i_ds import DefaultLedgerAccountIDs


class AccountingSettings(UniversalBaseModel):
    ledger_account_ids: typing.Optional[DefaultLedgerAccountIDs] = pydantic.Field(default=None)
    """
    Default ledger accounts that will be used for various objects pushed into an accounting system. Use `GET /ledger_accounts` to get the IDs of these ledger accounts.
    """

    tax_ids: typing.Optional[DefaultAccountingTaxIDs] = pydantic.Field(default=None)
    """
    Default accounting tax IDs that will be used for various objects pushed into an accounting system. Use `GET /accounting_tax_rates` to get the IDs of these taxes.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
