# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .tax_component_response import TaxComponentResponse


class AccountingTaxRateResponse(UniversalBaseModel):
    id: str
    code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Code for the tax rate from the accounting platform.
    """

    components: typing.Optional[typing.List[TaxComponentResponse]] = None
    effective_tax_rate: typing.Optional[int] = pydantic.Field(default=None)
    """
    Effective tax rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.
    """

    name: typing.Optional[str] = None
    status: typing.Optional[str] = None
    total_tax_rate: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total (not compounded) sum of the components of a tax rate in [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
