# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class AirwallexPlaidAccount(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Plaid`s unique identifier for the account
    """

    mask: str = pydantic.Field()
    """
    The last 2-4 alphanumeric characters of an account's official account number
    """

    name: str = pydantic.Field()
    """
    The name of the account, either assigned by the user or by the financial institution itself
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
