# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .approval_request_status import ApprovalRequestStatus
from .object_type import ObjectType


class ApprovalRequestResourceWithMetadata(UniversalBaseModel):
    id: str
    created_at: dt.datetime
    updated_at: dt.datetime
    approved_by: typing.List[str]
    created_by: str = pydantic.Field()
    """
    ID of the user who created the approval request
    """

    object_id: str
    object_type: ObjectType
    rejected_by: typing.Optional[str] = None
    required_approval_count: int
    role_ids: typing.List[str]
    status: ApprovalRequestStatus
    user_ids: typing.List[str]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
