# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries
from .currency_enum import CurrencyEnum


class BankAccount(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the bank account.
    """

    account_holder_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the person or business that owns this bank account.
    """

    account_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank account number. Typically used for UK and US bank accounts. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.
    """

    bic: typing.Optional[str] = pydantic.Field(default=None)
    """
    The BIC/SWIFT code of the bank.
    """

    country: typing.Optional[AllowedCountries] = pydantic.Field(default=None)
    """
    The country in which the bank account is registered, repsesented as a two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
    """

    currency: typing.Optional[CurrencyEnum] = pydantic.Field(default=None)
    """
    The currency of the bank account, represented as a three-letter ISO [currency code](https://docs.monite.com/references/currencies).
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-defined name of this bank account, such as 'Primary account' or 'Savings account'. Used only for entity bank accounts.
    """

    iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    The IBAN of the bank account.
    """

    is_default: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether this bank account is the default one for its currency.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-defined name of this bank account, such as 'Primary account' or 'Savings account'. Used only for counterpart bank accounts.
    """

    routing_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank's routing transit number (RTN). Typically used for US banks. US routing numbers consist of 9 digits.
    """

    sort_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank's sort code. Typically used for UK banks.
    """

    was_created_by_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the entity user who added this bank account, or `null` if it was added using a partner access token. Used only for entity bank accounts.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
