# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .receivable_type import ReceivableType


class BasedOnReceivableCreatedEventData(UniversalBaseModel):
    """
    In invoice history, this object contains information about a credit note created for this invoice.
    In quote history, it contains information about an invoice created from this quote.
    """

    receivable_id: str = pydantic.Field()
    """
    The ID of the newly created receivable document.
    """

    type: ReceivableType = pydantic.Field()
    """
    The type of the receivable document that was created based on the current document.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
