# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries
from .estimated_monthly_revenue import EstimatedMonthlyRevenue


class BusinessProfileOutput(UniversalBaseModel):
    description_of_goods_or_services: typing.Optional[str] = pydantic.Field(default=None)
    """
    Required for US entities. A free-form description of the products the entity sells (whether online or at offline retail stores) or the services it provides to its customers.
    """

    estimated_monthly_revenue: typing.Optional[EstimatedMonthlyRevenue] = pydantic.Field(default=None)
    """
    Required for US entities. The approximate revenue that the business generates per month.
    """

    mcc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The merchant category code of the entity. MCCs are used to classify businesses based on the goods or services they provide.
    """

    operating_countries: typing.Optional[typing.List[AllowedCountries]] = pydantic.Field(default=None)
    """
    Required for US entities. A list of primary countries where the business conducts its operations, such as selling products or providing services. Use two-letter country codes (ISO 3166-2 alpha-2).
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The business's publicly available website.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
