# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries
from .bank_account_verifications import BankAccountVerifications
from .currency_enum import CurrencyEnum


class CompleteVerificationResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Deprecated. Use bank_account_id instead.
    """

    account_holder_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Account holder's name
    """

    account_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Account number (required if IBAN is not provided)
    """

    bank_account_id: str
    bank_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the entity`s bank account.
    """

    bic: typing.Optional[str] = pydantic.Field(default=None)
    """
    The BIC of the entity`s bank account.
    """

    country: typing.Optional[AllowedCountries] = None
    currency: typing.Optional[CurrencyEnum] = None
    display_name: typing.Optional[str] = None
    iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    The IBAN of the entity`s bank account.
    """

    is_default: bool = pydantic.Field()
    """
    Marks if a bank account should be used by default for the currency. Only 1 can be True for each currency.
    """

    routing_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Routing number (US)
    """

    sort_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Sort code (GB)
    """

    verifications: BankAccountVerifications
    was_created_by_user_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
