# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries
from .currency_enum import CurrencyEnum


class CounterpartBankAccountResponse(UniversalBaseModel):
    id: str
    account_holder_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the person or business that owns this bank account. Required for US bank accounts to accept ACH payments.
    """

    account_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank account number. Required for US bank accounts to accept ACH payments. US account numbers contain 9 to 12 digits. UK account numbers typically contain 8 digits.
    """

    bic: typing.Optional[str] = pydantic.Field(default=None)
    """
    The BIC/SWIFT code of the bank.
    """

    counterpart_id: str
    country: AllowedCountries
    currency: CurrencyEnum
    iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    The IBAN of the bank account.
    """

    is_default_for_currency: typing.Optional[bool] = None
    name: typing.Optional[str] = None
    partner_metadata: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field(default=None)
    """
    Metadata for partner needs.
    """

    routing_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank's routing transit number (RTN). Required for US bank accounts to accept ACH payments. US routing numbers consist of 9 digits.
    """

    sort_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank's sort code.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
