# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .counterpart_address import CounterpartAddress


class CounterpartContactResponse(UniversalBaseModel):
    """
    The contact person for an organization.
    """

    id: str
    address: CounterpartAddress = pydantic.Field()
    """
    The address of a contact person.
    """

    counterpart_id: str
    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email address of a contact person.
    """

    first_name: str = pydantic.Field()
    """
    The first name of a contact person.
    """

    is_default: bool
    last_name: str = pydantic.Field()
    """
    The last name of a contact person.
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number of a contact person
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title or honorific of a contact person. Examples: Mr., Ms., Dr., Prof.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
