# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .counterpart_individual_create_payload import CounterpartIndividualCreatePayload
from .counterpart_organization_create_payload import CounterpartOrganizationCreatePayload
from .language_code_enum import LanguageCodeEnum


class CounterpartCreatePayload_Organization(UniversalBaseModel):
    """
    This schema is used to create new counterparts (either organizations or individuals).
    The counterpart type is specified by the `type` property. Depending on the `type`,
    you need to provide the data for either the `individual` or `organization` property.
    """

    type: typing.Literal["organization"] = "organization"
    external_reference: typing.Optional[str] = None
    language: typing.Optional[LanguageCodeEnum] = None
    organization: CounterpartOrganizationCreatePayload
    reminders_enabled: typing.Optional[bool] = None
    tax_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class CounterpartCreatePayload_Individual(UniversalBaseModel):
    """
    This schema is used to create new counterparts (either organizations or individuals).
    The counterpart type is specified by the `type` property. Depending on the `type`,
    you need to provide the data for either the `individual` or `organization` property.
    """

    type: typing.Literal["individual"] = "individual"
    external_reference: typing.Optional[str] = None
    individual: CounterpartIndividualCreatePayload
    language: typing.Optional[LanguageCodeEnum] = None
    reminders_enabled: typing.Optional[bool] = None
    tax_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


CounterpartCreatePayload = typing.Union[CounterpartCreatePayload_Organization, CounterpartCreatePayload_Individual]
