# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .counterpart_individual_create_payload import CounterpartIndividualCreatePayload
from .language_code_enum import LanguageCodeEnum


class CounterpartIndividualRootCreatePayload(UniversalBaseModel):
    """
    This schema is used to create counterparts that are individuals (natural persons).
    """

    external_reference: typing.Optional[str] = pydantic.Field(default=None)
    """
    A user-defined identifier of the counterpart. For example, the customer or vendor reference number in the entity's CRM system. If specified, it will be displayed in PDF invoices and other accounts receivable documents created by the entity.
    """

    individual: CounterpartIndividualCreatePayload
    language: typing.Optional[LanguageCodeEnum] = pydantic.Field(default=None)
    """
    The language used to generate PDF documents for this counterpart.
    """

    reminders_enabled: typing.Optional[bool] = None
    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The counterpart's taxpayer identification number or tax ID. For identification purposes, this field may be required for counterparts that are not VAT-registered.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
