# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CounterpartRawBankAccount(UniversalBaseModel):
    account_holder_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Vendor's bank account name.
    """

    account_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Vendor's bank account number, IBAN, or similar (if specified in the payable document).
    """

    bic: typing.Optional[str] = pydantic.Field(default=None)
    """
    SWIFT code (BIC) of the vendor's bank.
    """

    iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    required for non-GB bank accounts
    """

    sort_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    required for GB bank accounts
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
