# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .counterpart_raw_address import CounterpartRawAddress
from .counterpart_raw_bank_account import CounterpartRawBankAccount
from .counterpart_raw_vat_id import CounterpartRawVatId


class CounterpartRawData(UniversalBaseModel):
    address: typing.Optional[CounterpartRawAddress] = pydantic.Field(default=None)
    """
    The address of the vendor or supplier.
    """

    bank_account: typing.Optional[CounterpartRawBankAccount] = pydantic.Field(default=None)
    """
    Object representing counterpart bank account.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email address of the organization
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Vendor or supplier name.
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number of the organization
    """

    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tax id of the counterpart.
    """

    vat_id: typing.Optional[CounterpartRawVatId] = pydantic.Field(default=None)
    """
    VAT ID of the vendor or supplier which was used in the invoice.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
