# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CreditNoteLineItemCreateRequest(UniversalBaseModel):
    """
    Schema for creating a new credit note line item.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Detailed description of the line item
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name or title of the line item
    """

    quantity: typing.Optional[float] = pydantic.Field(default=None)
    """
    Quantity of items
    """

    tax: typing.Optional[int] = pydantic.Field(default=None)
    """
    VAT rate in percent [minor units](https://docs.monite.com/references/currencies#minor-units). Example: 12.5% is 1250.
    """

    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unit of measurement
    """

    unit_price: typing.Optional[int] = pydantic.Field(default=None)
    """
    Price per unit in smallest currency unit (e.g. cents)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
