# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CreditNoteLineItemResponse(UniversalBaseModel):
    """
    Schema for credit note line item response. Includes all fields that can be returned from the API.
    """

    id: str = pydantic.Field()
    """
    Unique identifier of the line item
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the line item was created
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Timestamp when the line item was last updated
    """

    created_by_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user who created the line item
    """

    credit_note_id: str = pydantic.Field()
    """
    ID of the parent credit note
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Detailed description of the line item
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name or title of the line item
    """

    quantity: typing.Optional[float] = pydantic.Field(default=None)
    """
    Quantity of items
    """

    subtotal: typing.Optional[int] = pydantic.Field(default=None)
    """
    Subtotal amount before tax
    """

    tax: typing.Optional[int] = pydantic.Field(default=None)
    """
    Tax percentage
    """

    tax_amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    Tax amount
    """

    total: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total amount including tax
    """

    unit: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unit of measurement
    """

    unit_price: typing.Optional[int] = pydantic.Field(default=None)
    """
    Price per unit in smallest currency unit
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
