# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CustomTemplateDataSchema(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    ID of email template
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Template created date and time
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Template updated date and time
    """

    body_template: str = pydantic.Field()
    """
    Jinja2 compatible email body template
    """

    is_default: bool = pydantic.Field()
    """
    Is default template
    """

    language: str = pydantic.Field()
    """
    Lowercase ISO code of language
    """

    name: str = pydantic.Field()
    """
    Name of the template
    """

    subject_template: str = pydantic.Field()
    """
    Jinja2 compatible email subject template
    """

    type: str = pydantic.Field()
    """
    Document type of content
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
