# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class DefaultLedgerAccountIDs(UniversalBaseModel):
    payments: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the ledger account to which all payment records will be pushed. Changing this value affects only future data pushes and does not affect payment records that already exist in the accounting system.
    """

    products: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the ledger account to which products without a `ledger_account_id` specified will be pushed. Changing this value affects only future data pushes and does not affect products that already exist in the accounting system.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
