# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .delivery_note_line_item_product import DeliveryNoteLineItemProduct


class DeliveryNoteCreateLineItem(UniversalBaseModel):
    product: typing.Optional[DeliveryNoteLineItemProduct] = pydantic.Field(default=None)
    """
    Object of product. Can be used instead of product_id, created in product's catalog
    """

    product_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier of the product.
    """

    quantity: float = pydantic.Field()
    """
    The quantity of each of the goods, materials, or services listed in the receivable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
