# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .delivery_note_create_line_item import DeliveryNoteCreateLineItem


class DeliveryNoteCreateRequest(UniversalBaseModel):
    """
    Delivery Note creation request schema
    """

    counterpart_address_id: str = pydantic.Field()
    """
    ID of the counterpart address selected for the delivery note
    """

    counterpart_id: str = pydantic.Field()
    """
    ID of the counterpart
    """

    delivery_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date of delivery
    """

    delivery_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Delivery number
    """

    display_signature_placeholder: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether to display a signature placeholder in the generated PDF
    """

    document_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Document ID of the delivery note
    """

    line_items: typing.List[DeliveryNoteCreateLineItem] = pydantic.Field()
    """
    List of line items in the delivery note
    """

    memo: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional information regarding the delivery note
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
