# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .delivery_note_counterpart_resource import DeliveryNoteCounterpartResource
from .delivery_note_line_item_resource import DeliveryNoteLineItemResource
from .delivery_note_resource_entity import DeliveryNoteResourceEntity
from .delivery_note_status_enum import DeliveryNoteStatusEnum
from .language_code_enum import LanguageCodeEnum
from .receivable_entity_address_schema import ReceivableEntityAddressSchema
from .receivables_counterpart_address import ReceivablesCounterpartAddress


class DeliveryNoteResource(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Unique ID of the delivery note
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the delivery note was created. Timestamps follow the ISO 8601 standard.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the delivery note was last updated. Timestamps follow the ISO 8601 standard.
    """

    based_on: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique ID of a previous document related to the delivery note if applicable.
    """

    based_on_document_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique document ID of a previous document related to the delivery note if applicable.
    """

    counterpart: DeliveryNoteCounterpartResource = pydantic.Field()
    """
    Counterpart of the delivery note
    """

    counterpart_address: ReceivablesCounterpartAddress = pydantic.Field()
    """
    Address of the counterpart
    """

    counterpart_id: str = pydantic.Field()
    """
    ID of the counterpart
    """

    created_by_entity_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the user that created the delivery note
    """

    delivery_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date of delivery
    """

    delivery_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    Delivery number
    """

    display_signature_placeholder: bool = pydantic.Field()
    """
    Whether to display a signature placeholder in the generated PDF
    """

    document_id: str = pydantic.Field()
    """
    Document ID of the delivery note
    """

    entity: DeliveryNoteResourceEntity = pydantic.Field()
    """
    Entity that created the delivery note
    """

    entity_address: ReceivableEntityAddressSchema = pydantic.Field()
    """
    Address of the entity that created the delivery note
    """

    entity_id: str = pydantic.Field()
    """
    ID of the entity that created the delivery note
    """

    file_language: LanguageCodeEnum = pydantic.Field()
    """
    The language of the customer-facing PDF file (`file_url`). The value matches the counterpart's `language` at the time when this PDF file was generated.
    """

    file_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The delivery note's PDF URL in the customer-facing language.
    """

    line_items: typing.List[DeliveryNoteLineItemResource] = pydantic.Field()
    """
    List of line items in the delivery note
    """

    memo: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional information regarding the delivery note
    """

    original_file_language: LanguageCodeEnum = pydantic.Field()
    """
    The language of the entity's copy of the PDF file (`original_file_url`). The value matches the entity's `language` at the time when this PDF file was generated.
    """

    original_file_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The delivery note's PDF URL in the entity's language.
    """

    status: DeliveryNoteStatusEnum = pydantic.Field()
    """
    Status of the delivery note
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
