# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .discount_type import DiscountType


class Discount(UniversalBaseModel):
    amount: int = pydantic.Field()
    """
    The actual discount of the product in [minor units](https://docs.monite.com/references/currencies#minor-units) if type field equals amount, else in percent minor units
    """

    type: DiscountType = pydantic.Field()
    """
    The field specifies whether to use product currency or %.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
