# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .dns_record_purpose import DnsRecordPurpose
from .dns_record_type import DnsRecordType


class DnsRecord(UniversalBaseModel):
    is_active: bool
    name: typing.Optional[str] = None
    record_purpose: typing.Optional[DnsRecordPurpose] = pydantic.Field(default=None)
    """
    Purpose of specific entry to distinguish between various TXT entries.
    """

    record_type: DnsRecordType
    valid: str = pydantic.Field()
    """
    Field reflecting validation status by Mailgun.
    """

    value: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
