# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .credit_note_rendering_settings import CreditNoteRenderingSettings
from .invoice_rendering_settings import InvoiceRenderingSettings
from .quote_rendering_settings import QuoteRenderingSettings


class DocumentRenderingSettings(UniversalBaseModel):
    credit_note: typing.Optional[CreditNoteRenderingSettings] = pydantic.Field(default=None)
    """
    Settings for rendering credit notes in PDF documents.
    """

    invoice: typing.Optional[InvoiceRenderingSettings] = pydantic.Field(default=None)
    """
    Settings for rendering invoices in PDF documents.
    """

    quote: typing.Optional[QuoteRenderingSettings] = pydantic.Field(default=None)
    """
    Settings for rendering quotes in PDF documents.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
