# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .domain_response_dns_records import DomainResponseDnsRecords


class DomainResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    Entry UUID
    """

    dedicated_ip: typing.Optional[str] = pydantic.Field(default=None)
    """
    A dedicated IP address assigned to this mailbox and used to send outgoing email.
    """

    dns_records: DomainResponseDnsRecords
    domain: str = pydantic.Field()
    """
    The domain name.
    """

    last_updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time the domain was updated for the last time
    """

    status: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
