# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_einvoicing_country_codes import AllowedEinvoicingCountryCodes


class EinvoicingAddress(UniversalBaseModel):
    address_line1: str = pydantic.Field()
    """
    Street address line 1
    """

    address_line2: typing.Optional[str] = pydantic.Field(default=None)
    """
    Street address line 2
    """

    city: str = pydantic.Field()
    """
    City name
    """

    country: AllowedEinvoicingCountryCodes = pydantic.Field()
    """
    Country name
    """

    postal_code: str = pydantic.Field()
    """
    Postal/ZIP code
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    State/Province/County
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
