# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .einvoicing_address import EinvoicingAddress
from .einvoicing_network_credentials_response import EinvoicingNetworkCredentialsResponse


class EinvoicingConnectionResponse(UniversalBaseModel):
    id: str
    created_at: dt.datetime = pydantic.Field()
    """
    Date of Integration
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last update of Integration
    """

    address: EinvoicingAddress = pydantic.Field()
    """
    Integration Address
    """

    credentials: typing.List[EinvoicingNetworkCredentialsResponse] = pydantic.Field()
    """
    List of credentials
    """

    entity_id: str = pydantic.Field()
    """
    ID of the entity
    """

    legal_name: str = pydantic.Field()
    """
    Legal name of the Entity
    """

    provider_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID assigned by integration partner
    """

    status: str = pydantic.Field()
    """
    Current status of the integration
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
