# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .einvoice_schema_type_enum import EinvoiceSchemaTypeEnum


class EinvoicingNetworkCredentialsResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    ID of the credentials
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Date of credential
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Last update of credential
    """

    einvoicing_connection_id: str = pydantic.Field()
    """
    ID of the Einvoicing connection
    """

    network_credentials_identifier: str = pydantic.Field()
    """
    Network participant identifier
    """

    network_credentials_schema: EinvoiceSchemaTypeEnum = pydantic.Field()
    """
    Network scheme identifier
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
