# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .allowed_countries import AllowedCountries
from .currency_enum import CurrencyEnum


class EntityBankAccountResponse(UniversalBaseModel):
    """
    Represents a bank account owned by an entity.
    """

    id: str = pydantic.Field()
    """
    Unique ID of the bank account.
    """

    account_holder_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the person or business that owns this bank account. Required in the following cases:
    * the account currency is GBP or USD,
    * the account currency is EUR and the entity wishes to receive SEPA Credit transfers to this account.
    """

    account_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank account number. Required if the account currency is GBP or USD. UK account numbers typically contain 8 digits. US bank account numbers contain 9 to 12 digits.
    """

    bank_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank name.
    """

    bic: typing.Optional[str] = pydantic.Field(default=None)
    """
    The SWIFT/BIC code of the bank. Can be either 8 or 11 characters long. Monite verifies the BIC length, country code, and whether the structure conforms to ISO 9362.
    
    If `bic` is specified, `iban` must also be specified.
    """

    country: typing.Optional[AllowedCountries] = pydantic.Field(default=None)
    """
    The country in which the bank account is registered, repsesented as a two-letter country code ([ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)).
    """

    currency: typing.Optional[CurrencyEnum] = pydantic.Field(default=None)
    """
    The currency of the bank account, represented as a three-letter ISO [currency code](https://docs.monite.com/references/currencies).
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    User-defined name of this bank account, such as 'Primary account' or 'Savings account'.
    """

    iban: typing.Optional[str] = pydantic.Field(default=None)
    """
    The IBAN of the bank account, up to 34 characters. Required if the account currency is EUR. Monite verifies the IBAN length, checksum digits, and country-specific format according to ISO 13616.
    """

    is_default_for_currency: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether this bank account is the default one for its currency.
    """

    routing_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank's routing transit number (RTN) or branch code. Required if the account currency is USD. US routing numbers consist of 9 digits.
    """

    sort_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The bank's sort code. Required if the account currency is GBP.
    """

    was_created_by_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    ID of the entity user who added this bank account, or `null` if it was added using a partner access token.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
