# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .entity_address_response_schema import EntityAddressResponseSchema
from .entity_status_enum import EntityStatusEnum
from .file_schema2 import FileSchema2
from .individual_response_schema import IndividualResponseSchema


class EntityIndividualResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    UUID entity ID
    """

    created_at: dt.datetime = pydantic.Field()
    """
    UTC datetime
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    UTC datetime
    """

    address: EntityAddressResponseSchema = pydantic.Field()
    """
    An address description of the entity
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    An official email address of the entity
    """

    individual: IndividualResponseSchema = pydantic.Field()
    """
    A set of metadata describing an individual
    """

    logo: typing.Optional[FileSchema2] = pydantic.Field(default=None)
    """
    A logo image of the entity
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    A phone number of the entity
    """

    registration_authority: typing.Optional[str] = pydantic.Field(default=None)
    """
    (Germany only) The name of the local district court (_Amtsgericht_) where the entity is registered. Required if `registration_number` is provided.
    """

    registration_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    (Germany only) The entity's commercial register number (_Handelsregisternummer_) in the German Commercial Register, if available.
    """

    status: EntityStatusEnum = pydantic.Field()
    """
    record status, 'active' by default
    """

    tax_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The entity's taxpayer identification number or tax ID. This field is required for entities that are non-VAT registered.
    """

    website: typing.Optional[str] = pydantic.Field(default=None)
    """
    A website of the entity
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
