# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .business_profile_output import BusinessProfileOutput
from .ownership_declaration_output import OwnershipDeclarationOutput
from .terms_of_service_acceptance_output import TermsOfServiceAcceptanceOutput


class EntityOnboardingDataResponse(UniversalBaseModel):
    business_profile: typing.Optional[BusinessProfileOutput] = pydantic.Field(default=None)
    """
    Business information about the entity.
    """

    ownership_declaration: typing.Optional[OwnershipDeclarationOutput] = pydantic.Field(default=None)
    """
    Used to attest that the beneficial owner information provided is both current and correct.
    """

    tos_acceptance: typing.Optional[TermsOfServiceAcceptanceOutput] = pydantic.Field(default=None)
    """
    Details on the entity's acceptance of the service agreement.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
