# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .currency_enum import CurrencyEnum


class EstimatedMonthlyRevenue(UniversalBaseModel):
    amount: typing.Optional[int] = pydantic.Field(default=None)
    """
    The amount of the monthly revenue, in [minor units](https://docs.monite.com/references/currencies#minor-units). For example, $12.50 is represented as 1250.
    """

    currency: typing.Optional[CurrencyEnum] = pydantic.Field(default=None)
    """
    [Currency code](https://docs.monite.com/references/currencies) of the revenue.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
