# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .webhook_object_type import WebhookObjectType


class EventResource(UniversalBaseModel):
    id: str
    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp that was generated at the time of making the database transaction that has initially caused the event
    """

    action: str
    api_version: typing.Optional[str] = None
    description: str
    entity_id: str
    object: typing.Optional[typing.Optional[typing.Any]] = None
    object_type: WebhookObjectType

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
